/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.math.BigInteger;
import java.util.Random;
import java.util.function.Function;
import net.jqwik.api.RandomDistribution;

class SizeGenerator {
    private SizeGenerator() {
    }

    static Function<Random, Integer> create(int minSize, int maxSize, int genSize, RandomDistribution distribution) {
        if (distribution != null) {
            return SizeGenerator.sizeGeneratorWithDistribution(minSize, maxSize, genSize, distribution);
        }
        return SizeGenerator.sizeGeneratorWithCutoff(minSize, maxSize, genSize);
    }

    private static Function<Random, Integer> sizeGeneratorWithDistribution(int minSize, int maxSize, int genSize, RandomDistribution distribution) {
        RandomDistribution.RandomNumericGenerator generator = distribution.createGenerator(genSize, BigInteger.valueOf(minSize), BigInteger.valueOf(maxSize), BigInteger.valueOf(minSize));
        return random -> generator.next(random).intValueExact();
    }

    private static Function<Random, Integer> sizeGeneratorWithCutoff(int minSize, int maxSize, int genSize) {
        int cutoffSize = SizeGenerator.cutoffSize(minSize, maxSize, genSize);
        if (cutoffSize >= maxSize) {
            return random -> SizeGenerator.randomSize(random, minSize, maxSize);
        }
        double maxSizeProbability = Math.min(0.02, 1.0 / ((double)genSize / 10.0));
        double cutoffProbability = 0.1;
        return random -> {
            if (random.nextDouble() <= maxSizeProbability) {
                return maxSize;
            }
            if (random.nextDouble() <= cutoffProbability + maxSizeProbability) {
                return SizeGenerator.randomSize(random, cutoffSize + 1, maxSize);
            }
            return SizeGenerator.randomSize(random, minSize, cutoffSize);
        };
    }

    private static int cutoffSize(int minSize, int maxSize, int genSize) {
        int range = maxSize - minSize;
        int offset = (int)Math.max(Math.round(Math.sqrt(genSize)), 10L);
        if (range <= offset) {
            return maxSize;
        }
        return Math.min(offset + minSize, maxSize);
    }

    private static int randomSize(Random random, int minSize, int maxSize) {
        int range = maxSize - minSize;
        return random.nextInt(range + 1) + minSize;
    }
}

