/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.state;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.jqwik.api.Tuple;
import net.jqwik.api.state.ActionChain;
import net.jqwik.api.state.Chain;
import net.jqwik.api.support.HashCodeSupport;
import net.jqwik.engine.properties.state.InvariantFailedError;
import net.jqwik.engine.support.JqwikStringSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.TestAbortedException;

public class SequentialActionChain<T>
implements ActionChain<T> {
    private final Chain<T> chain;
    private volatile T currentValue = null;
    private volatile ActionChain.RunningState currentRunning = ActionChain.RunningState.NOT_RUN;
    private final List<Consumer<T>> peekers = new ArrayList<Consumer<T>>();
    private final List<Tuple.Tuple2<String, Consumer<T>>> invariants = new ArrayList<Tuple.Tuple2<String, Consumer<T>>>();

    public SequentialActionChain(Chain<T> chain) {
        this.chain = chain;
    }

    @NotNull
    public List<String> transformations() {
        return this.chain.transformations();
    }

    @NotNull
    public synchronized T run() {
        this.currentRunning = ActionChain.RunningState.RUNNING;
        Iterator iterator = this.chain.iterator();
        while (iterator.hasNext()) {
            this.nextAction(iterator);
        }
        this.currentRunning = ActionChain.RunningState.SUCCEEDED;
        return this.currentValue;
    }

    private void nextAction(Iterator<T> iterator) {
        try {
            T state = iterator.next();
            this.currentValue = state;
            this.callPeekers();
            this.checkInvariants();
        }
        catch (InvariantFailedError ife) {
            this.currentRunning = ActionChain.RunningState.FAILED;
            throw ife;
        }
        catch (TestAbortedException testAbortedException) {
            throw testAbortedException;
        }
        catch (Throwable t) {
            this.currentRunning = ActionChain.RunningState.FAILED;
            AssertionFailedError assertionFailedError = new AssertionFailedError(this.createErrorMessage("Run", t.getMessage()), t);
            assertionFailedError.setStackTrace(t.getStackTrace());
            throw assertionFailedError;
        }
    }

    private void callPeekers() {
        for (Consumer<T> peeker : this.peekers) {
            peeker.accept(this.currentValue);
        }
    }

    private void checkInvariants() {
        for (Tuple.Tuple2<String, Consumer<T>> tuple : this.invariants) {
            String label = (String)tuple.get1();
            Consumer invariant = (Consumer)tuple.get2();
            try {
                invariant.accept(this.currentValue);
            }
            catch (Throwable t) {
                throw new InvariantFailedError(this.createErrorMessage(label, t.getMessage()), t);
            }
        }
    }

    private String createErrorMessage(String name, String causeMessage) {
        String actionsString = this.transformations().stream().map(transformation -> "    " + transformation).collect(Collectors.joining(System.lineSeparator()));
        return String.format("%s failed after the following actions: [%s]%nfinal state: %s%n%s", name, actionsString.isEmpty() ? "" : String.format("%n%s  %n", actionsString), JqwikStringSupport.displayString(this.currentValue), causeMessage);
    }

    @NotNull
    public ActionChain<T> withInvariant(@Nullable String label, Consumer<T> invariant) {
        String invariantLabel = label == null ? "Invariant" : String.format("Invariant '%s'", label);
        this.invariants.add(Tuple.of((Object)invariantLabel, invariant));
        return this;
    }

    @NotNull
    public synchronized Optional<T> finalState() {
        return Optional.ofNullable(this.currentValue);
    }

    @NotNull
    public ActionChain.RunningState running() {
        return this.currentRunning;
    }

    @NotNull
    public synchronized ActionChain<T> peek(@NotNull Consumer<T> peeker) {
        this.peekers.add(peeker);
        return this;
    }

    public String toString() {
        if (this.running() == ActionChain.RunningState.NOT_RUN) {
            return String.format("ActionChain[%s]: %s max actions", this.running().name(), this.chain.maxTransformations());
        }
        String actionsString = JqwikStringSupport.displayString(this.transformations());
        return String.format("ActionChain[%s]: %s", this.running().name(), actionsString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequentialActionChain that = (SequentialActionChain)o;
        return this.currentRunning == that.currentRunning;
    }

    public int hashCode() {
        return HashCodeSupport.hash(this.currentValue, (Object)this.currentRunning);
    }
}

