/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.api.state.Chain;
import net.jqwik.api.state.Transformer;
import net.jqwik.engine.properties.state.ShrinkableChain;
import net.jqwik.engine.properties.state.ShrinkableChainIteration;
import net.jqwik.engine.support.Combinatorics;
import net.jqwik.engine.support.JqwikStreamSupport;

class ShrinkableChainShrinker<T> {
    private final ShrinkableChain<T> shrinkable;
    private final List<ShrinkableChainIteration<T>> iterations;
    private final int maxTransformations;

    ShrinkableChainShrinker(ShrinkableChain<T> shrinkableChain, List<ShrinkableChainIteration<T>> iterations, int maxTransformations) {
        this.shrinkable = shrinkableChain;
        this.iterations = iterations;
        this.maxTransformations = maxTransformations;
    }

    public Stream<Shrinkable<Chain<T>>> shrink() {
        if (this.iterations.isEmpty()) {
            return Stream.empty();
        }
        return JqwikStreamSupport.concat(this.shrinkMaxTransformations(), this.shrinkLastStateAccessingTransformer(), this.shrinkRanges(), this.shrinkTransformersWithoutStateChange());
    }

    private Stream<Shrinkable<Chain<T>>> shrinkTransformersWithoutStateChange() {
        int indexLastStateAccess = this.indexOfLastIterationWithStateAccess();
        if (indexLastStateAccess > 0) {
            ArrayList<ShrinkableChain<T>> shrunkChains = new ArrayList<ShrinkableChain<T>>();
            for (int i = 0; i < indexLastStateAccess; ++i) {
                ShrinkableChainIteration<T> currentIteration = this.iterations.get(i);
                if (currentIteration.changeState) continue;
                ArrayList<ShrinkableChainIteration<T>> shrunkIterations = new ArrayList<ShrinkableChainIteration<T>>(this.iterations);
                shrunkIterations.remove(i);
                shrunkChains.add(this.newShrinkableChain(shrunkIterations, this.maxTransformations - 1));
            }
            return shrunkChains.stream();
        }
        return Stream.empty();
    }

    private int indexOfLastIterationWithStateAccess() {
        for (int i = this.iterations.size() - 1; i >= 0; --i) {
            ShrinkableChainIteration<T> iteration = this.iterations.get(i);
            if (!iteration.accessState) continue;
            return i;
        }
        return -1;
    }

    private Stream<Shrinkable<Chain<T>>> shrinkMaxTransformations() {
        if (this.iterations.size() < this.maxTransformations) {
            return Stream.of(this.newShrinkableChain(this.iterations, this.iterations.size()));
        }
        return Stream.empty();
    }

    private Stream<Shrinkable<Chain<T>>> shrinkLastStateAccessingTransformer() {
        int indexLastIterationWithStateAccess = this.indexOfLastIterationWithStateAccess();
        if (indexLastIterationWithStateAccess >= 0) {
            ArrayList<ShrinkableChainIteration<T>> shrunkIterations = new ArrayList<ShrinkableChainIteration<T>>(this.iterations);
            shrunkIterations.remove(indexLastIterationWithStateAccess);
            return Stream.of(this.newShrinkableChain(shrunkIterations, this.maxTransformations - 1));
        }
        return Stream.empty();
    }

    private Stream<Shrinkable<Chain<T>>> shrinkRanges() {
        return this.splitIntoRanges().stream().flatMap(range -> this.shrinkIterationsRange((Integer)range.get1(), (Integer)range.get2()));
    }

    private Stream<ShrinkableChain<T>> shrinkIterationsRange(int startIndex, int endIndex) {
        List<ShrinkableChainIteration<T>> iterationsRange = this.extractRange(startIndex, endIndex);
        return JqwikStreamSupport.concat(this.shrinkAllSubRanges(startIndex, iterationsRange), this.shrinkOneAfterTheOther(startIndex, iterationsRange), this.shrinkPairs(startIndex, iterationsRange));
    }

    private List<ShrinkableChainIteration<T>> extractRange(int startIndex, int endIndex) {
        ArrayList<ShrinkableChainIteration<T>> iterationsRange = new ArrayList<ShrinkableChainIteration<T>>();
        for (int i = 0; i < this.iterations.size(); ++i) {
            if (i < startIndex || i > endIndex) continue;
            iterationsRange.add(this.iterations.get(i));
        }
        return iterationsRange;
    }

    private Stream<ShrinkableChain<T>> shrinkPairs(int startIndex, List<ShrinkableChainIteration<T>> iterationsRange) {
        Stream<List<ShrinkableChainIteration<T>>> shrunkRange = this.shrinkPairsOfIterations(iterationsRange);
        int restSize = this.iterations.size() - iterationsRange.size();
        return this.replaceRangeByShrunkRange(startIndex, shrunkRange, restSize);
    }

    private Stream<List<ShrinkableChainIteration<T>>> shrinkPairsOfIterations(List<ShrinkableChainIteration<T>> iterationsRange) {
        return Combinatorics.distinctPairs(iterationsRange.size()).flatMap(pair -> {
            ShrinkableChainIteration first = (ShrinkableChainIteration)iterationsRange.get((Integer)pair.get1());
            ShrinkableChainIteration second = (ShrinkableChainIteration)iterationsRange.get((Integer)pair.get2());
            return JqwikStreamSupport.zip(first.shrinkable.shrink(), second.shrinkable.shrink(), (s1, s2) -> {
                ArrayList newElements = new ArrayList(iterationsRange);
                newElements.set((Integer)pair.get1(), first.withShrinkable(s1));
                newElements.set((Integer)pair.get2(), second.withShrinkable(s2));
                return newElements;
            });
        });
    }

    private Stream<ShrinkableChain<T>> shrinkOneAfterTheOther(int startIndex, List<ShrinkableChainIteration<T>> iterationsRange) {
        Stream<List<ShrinkableChainIteration<T>>> shrunkRange = this.shrinkOneIterationAfterTheOther(iterationsRange);
        int restSize = this.iterations.size() - iterationsRange.size();
        return this.replaceRangeByShrunkRange(startIndex, shrunkRange, restSize);
    }

    private Stream<ShrinkableChain<T>> shrinkAllSubRanges(int startIndex, List<ShrinkableChainIteration<T>> iterationsRange) {
        Stream<List<ShrinkableChainIteration<T>>> shrunkRange = this.shrinkToAllSubLists(iterationsRange);
        int restSize = this.iterations.size() - iterationsRange.size();
        return this.replaceRangeByShrunkRange(startIndex, shrunkRange, restSize);
    }

    private Stream<List<ShrinkableChainIteration<T>>> shrinkOneIterationAfterTheOther(List<ShrinkableChainIteration<T>> iterationsRange) {
        ArrayList shrinkPerElementStreams = new ArrayList();
        for (int i = 0; i < iterationsRange.size(); ++i) {
            int index = i;
            ShrinkableChainIteration iteration = iterationsRange.get(i);
            Shrinkable element = iteration.shrinkable;
            Stream shrinkElement = element.shrink().flatMap(shrunkElement -> {
                ArrayList iterationsCopy = new ArrayList(iterationsRange);
                iterationsCopy.set(index, iteration.withShrinkable((Shrinkable)shrunkElement));
                return Stream.of(iterationsCopy);
            });
            shrinkPerElementStreams.add(shrinkElement);
        }
        return JqwikStreamSupport.concat(shrinkPerElementStreams);
    }

    private Stream<ShrinkableChain<T>> replaceRangeByShrunkRange(int startIndex, Stream<List<ShrinkableChainIteration<T>>> shrunkRange, int restSize) {
        return shrunkRange.map(shrunkIterationsRange -> {
            ArrayList<ShrinkableChainIteration<T>> shrunkIterations = new ArrayList<ShrinkableChainIteration<T>>();
            for (int i = 0; i < startIndex; ++i) {
                shrunkIterations.add(this.iterations.get(i));
            }
            shrunkIterations.addAll((Collection<ShrinkableChainIteration<T>>)shrunkIterationsRange);
            int newMaxSize = restSize + shrunkIterationsRange.size();
            return this.newShrinkableChain(shrunkIterations, newMaxSize);
        });
    }

    private Stream<List<ShrinkableChainIteration<T>>> shrinkToAllSubLists(List<ShrinkableChainIteration<T>> iterations) {
        LinkedHashSet<ArrayList<ShrinkableChainIteration<T>>> setOfSequences = new LinkedHashSet<ArrayList<ShrinkableChainIteration<T>>>();
        for (int i = 0; i < iterations.size(); ++i) {
            if (this.isUnshrinkableEndOfChain(iterations.get(i))) continue;
            ArrayList<ShrinkableChainIteration<T>> newCandidate = new ArrayList<ShrinkableChainIteration<T>>(iterations);
            newCandidate.remove(i);
            setOfSequences.add(newCandidate);
        }
        return setOfSequences.stream();
    }

    private boolean isUnshrinkableEndOfChain(ShrinkableChainIteration<T> iteration) {
        return this.isInfinite() && iteration.isEndOfChain();
    }

    private List<Tuple.Tuple2<Integer, Integer>> splitIntoRanges() {
        ArrayList<Tuple.Tuple2<Integer, Integer>> ranges = new ArrayList<Tuple.Tuple2<Integer, Integer>>();
        int end = 0;
        block0: for (int i = this.iterations.size() - 1; i >= 0; --i) {
            end = i;
            while (i >= 0) {
                ShrinkableChainIteration<T> current = this.iterations.get(i);
                if (current.accessState || i == 0) {
                    ranges.add((Tuple.Tuple2<Integer, Integer>)Tuple.of((Object)i, (Object)end));
                    continue block0;
                }
                --i;
            }
        }
        return ranges;
    }

    private ShrinkableChain<T> newShrinkableChain(List<ShrinkableChainIteration<T>> shrunkIterations, int newMaxTransformations) {
        int effectiveNewMax;
        int n = effectiveNewMax = this.isInfinite() ? -1 : newMaxTransformations;
        if (this.isInfinite() && !shrunkIterations.get(shrunkIterations.size() - 1).isEndOfChain()) {
            shrunkIterations.add(new ShrinkableChainIteration(null, false, Shrinkable.unshrinkable((Object)Transformer.endOfChain())));
        }
        return this.shrinkable.cloneWith(shrunkIterations, effectiveNewMax);
    }

    private boolean isInfinite() {
        return this.maxTransformations < 0;
    }
}

