/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.reporting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import net.jqwik.api.SampleReportingFormat;

public class ArrayReportingFormat
implements SampleReportingFormat {
    public boolean appliesTo(Object value) {
        return value.getClass().isArray();
    }

    public Object report(Object value) {
        Class<?> arrayClass = value.getClass();
        if (arrayClass.equals(byte[].class)) {
            ArrayList<Byte> list = new ArrayList<Byte>();
            for (byte v : (byte[])value) {
                list.add(v);
            }
            return list;
        }
        if (arrayClass.equals(short[].class)) {
            ArrayList<Short> list = new ArrayList<Short>();
            for (short v : (short[])value) {
                list.add(v);
            }
            return list;
        }
        if (arrayClass.equals(int[].class)) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int v : (int[])value) {
                list.add(v);
            }
            return list;
        }
        if (arrayClass.equals(long[].class)) {
            ArrayList<Long> list = new ArrayList<Long>();
            for (long v : (long[])value) {
                list.add(v);
            }
            return list;
        }
        if (arrayClass.equals(char[].class)) {
            ArrayList<Character> list = new ArrayList<Character>();
            for (char v : (char[])value) {
                list.add(Character.valueOf(v));
            }
            return list;
        }
        if (arrayClass.equals(float[].class)) {
            ArrayList<Float> list = new ArrayList<Float>();
            for (float v : (float[])value) {
                list.add(Float.valueOf(v));
            }
            return list;
        }
        if (arrayClass.equals(double[].class)) {
            ArrayList<Double> list = new ArrayList<Double>();
            for (double v : (double[])value) {
                list.add(v);
            }
            return list;
        }
        if (arrayClass.equals(boolean[].class)) {
            ArrayList<Boolean> list = new ArrayList<Boolean>();
            for (boolean v : (boolean[])value) {
                list.add(v);
            }
            return list;
        }
        return Arrays.asList((Object[])value);
    }

    public Optional<String> label(Object value) {
        Class<?> arrayClass = value.getClass();
        String baseClassName = arrayClass.getTypeName().startsWith("java.lang") ? arrayClass.getSimpleName() : arrayClass.getTypeName();
        return Optional.of(String.format("%s ", baseClassName));
    }
}

