/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ArbitrarySupplier;
import net.jqwik.api.ForAll;
import net.jqwik.api.From;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Provide;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.api.support.CollectorsSupport;
import net.jqwik.engine.properties.ProviderMethodInvoker;
import net.jqwik.engine.support.JqwikReflectionSupport;
import net.jqwik.engine.support.OverriddenMethodAnnotationSupport;

abstract class InstanceBasedSubtypeProvider
implements ArbitraryProvider.SubtypeProvider {
    private final Object instance;

    protected InstanceBasedSubtypeProvider(Object instance) {
        this.instance = instance;
    }

    public Set<Arbitrary<?>> apply(TypeUsage targetType) {
        Set<Arbitrary<?>> resolvedArbitraries;
        long countSpecs;
        Class supplier;
        Class supplier2;
        Optional optionalForAll = targetType.findAnnotation(ForAll.class);
        Optional<String> optionalForAllValue = optionalForAll.map(ForAll::value).filter(name -> !name.equals(""));
        Optional<Class<? extends ArbitrarySupplier<?>>> optionalForAllSupplier = Optional.empty();
        if (optionalForAll.isPresent() && !(supplier2 = ((ForAll)optionalForAll.get()).supplier()).equals(ArbitrarySupplier.NONE.class)) {
            optionalForAllSupplier = Optional.of(supplier2);
        }
        Optional optionalFrom = targetType.findAnnotation(From.class);
        Optional<String> optionalFromValue = optionalFrom.map(From::value).filter(name -> !name.equals(""));
        Optional<Object> optionalFromSupplier = Optional.empty();
        if (optionalFrom.isPresent() && !(supplier = ((From)optionalFrom.get()).supplier()).equals(ArbitrarySupplier.NONE.class)) {
            optionalFromSupplier = Optional.of(supplier);
        }
        if ((countSpecs = Stream.of(optionalForAllValue, optionalForAllSupplier, optionalFromValue, optionalFromSupplier).filter(Optional::isPresent).map(Optional::get).count()) == 0L) {
            resolvedArbitraries = this.resolve(targetType);
        } else if (countSpecs == 1L) {
            resolvedArbitraries = optionalForAllValue.isPresent() || optionalFromValue.isPresent() ? this.resolveFromGeneratorName(targetType, optionalForAllValue, optionalFromValue) : this.resolveFromSupplier(targetType, optionalForAllSupplier, optionalFromSupplier);
        } else {
            return this.onlyOneSpecAllowedError(targetType, countSpecs);
        }
        return (Set)resolvedArbitraries.stream().map(arbitrary -> this.configure((Arbitrary<?>)arbitrary, targetType)).filter(Objects::nonNull).collect(CollectorsSupport.toLinkedHashSet());
    }

    private Set<Arbitrary<?>> resolveFromSupplier(TypeUsage targetType, Optional<Class<? extends ArbitrarySupplier<?>>> optionalForAllSupplier, Optional<? extends Class<? extends ArbitrarySupplier<?>>> optionalFromSupplier) {
        Class supplierClass = optionalForAllSupplier.orElseGet(() -> (Class)optionalFromSupplier.orElseThrow(() -> new JqwikException("Should never happen")));
        ArbitrarySupplier supplier = (ArbitrarySupplier)JqwikReflectionSupport.newInstanceInTestContext(supplierClass, this.instance);
        Arbitrary arbitrary = supplier.supplyFor(targetType);
        if (arbitrary == null) {
            String message = String.format("Supplier [%s] for type [%s] returns null but should return an arbitrary", supplierClass, targetType);
            throw new JqwikException(message);
        }
        return Collections.singleton(arbitrary);
    }

    private Set<Arbitrary<?>> resolveFromGeneratorName(TypeUsage targetType, Optional<String> optionalForAllValue, Optional<String> optionalFromValue) {
        String generatorName = optionalForAllValue.orElseGet(() -> (String)optionalFromValue.orElseThrow(() -> new JqwikException("Should never happen")));
        return this.findArbitraryGeneratorByName(targetType, generatorName).map(providerMethod -> this.invokeProviderMethod((Method)providerMethod, targetType)).orElse(Collections.emptySet());
    }

    private Set<Arbitrary<?>> onlyOneSpecAllowedError(TypeUsage targetType, long countSpecs) {
        String message = String.format("You can only have one arbitrary specification per parameter, but you have %s:%n%s", countSpecs, targetType);
        throw new JqwikException(message);
    }

    private Set<Arbitrary<?>> invokeProviderMethod(Method providerMethod, TypeUsage targetType) {
        return new ProviderMethodInvoker(providerMethod, targetType, this.instance, this).invoke();
    }

    private Optional<Method> findArbitraryGeneratorByName(TypeUsage typeUsage, String generatorToFind) {
        if (generatorToFind.isEmpty()) {
            return Optional.empty();
        }
        Function<Method, String> generatorNameSupplier = method -> {
            Optional<Provide> provideAnnotation = OverriddenMethodAnnotationSupport.findDeclaredOrInheritedAnnotation(method, Provide.class);
            return provideAnnotation.map(Provide::value).orElse("");
        };
        TypeUsage targetArbitraryType = TypeUsage.of(Arbitrary.class, (TypeUsage[])new TypeUsage[]{typeUsage});
        return JqwikReflectionSupport.findGeneratorMethod(generatorToFind, this.instance.getClass(), Provide.class, generatorNameSupplier, targetArbitraryType);
    }

    protected abstract Set<Arbitrary<?>> resolve(TypeUsage var1);

    protected abstract Arbitrary<?> configure(Arbitrary<?> var1, TypeUsage var2);
}

