/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.configurators.SelfConfiguringArbitrary;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

public class FrequencyOfArbitrary<T>
implements Arbitrary<T>,
SelfConfiguringArbitrary<T> {
    private final List<Tuple.Tuple2<Integer, Arbitrary<T>>> frequencies;
    private final boolean isGeneratorMemoizable;

    public FrequencyOfArbitrary(List<Tuple.Tuple2<Integer, Arbitrary<T>>> frequencies) {
        this.frequencies = frequencies;
        this.isGeneratorMemoizable = frequencies.stream().allMatch(t -> ((Arbitrary)t.get2()).isGeneratorMemoizable());
        if (this.frequencies.isEmpty()) {
            throw new JqwikException("At least one frequency must be above 0");
        }
    }

    public RandomGenerator<T> generator(int genSize) {
        return RandomGenerators.frequencyOf(this.frequencies, genSize, false);
    }

    public RandomGenerator<T> generatorWithEmbeddedEdgeCases(int genSize) {
        return RandomGenerators.frequencyOf(this.frequencies, genSize, true);
    }

    public boolean isGeneratorMemoizable() {
        return this.isGeneratorMemoizable;
    }

    public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.choose(this.allArbitraries(), maxNumberOfSamples).flatMap(generator -> ExhaustiveGenerators.flatMap(generator, Function.identity(), maxNumberOfSamples));
    }

    public EdgeCases<T> edgeCases(int maxEdgeCases) {
        return EdgeCasesSupport.concatFrom(this.allArbitraries(), maxEdgeCases);
    }

    private List<Arbitrary<T>> allArbitraries() {
        return this.frequencies.stream().map(Tuple.Tuple2::get2).collect(Collectors.toList());
    }

    public Arbitrary<T> configure(ArbitraryConfigurator configurator, TypeUsage targetType) {
        this.frequencies.replaceAll(f -> {
            Arbitrary configuredArbitrary = SelfConfiguringArbitrary.configure((Arbitrary)((Arbitrary)f.get2()), (ArbitraryConfigurator)configurator, (TypeUsage)targetType);
            return Tuple.of((Object)((Integer)f.get1()), (Object)configuredArbitrary);
        });
        return configurator.configure((Arbitrary)this, targetType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrequencyOfArbitrary that = (FrequencyOfArbitrary)o;
        return this.frequencies.equals(that.frequencies);
    }

    public int hashCode() {
        return this.frequencies.hashCode();
    }
}

