/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.lifecycle;

import java.util.ArrayList;
import java.util.List;
import net.jqwik.api.lifecycle.AfterContainerHook;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.AroundTryHook;
import net.jqwik.api.lifecycle.BeforeContainerHook;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyExecutor;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.api.lifecycle.SkipExecutionHook;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.api.lifecycle.TryExecutor;
import net.jqwik.engine.execution.lifecycle.CombinedResolveParameterHook;
import net.jqwik.engine.support.JqwikExceptionSupport;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;
import org.opentest4j.TestAbortedException;

public class HookSupport {
    public static AroundPropertyHook combineAroundPropertyHooks(List<AroundPropertyHook> aroundPropertyHooks) {
        if (aroundPropertyHooks.isEmpty()) {
            return AroundPropertyHook.BASE;
        }
        aroundPropertyHooks = new ArrayList<AroundPropertyHook>(aroundPropertyHooks);
        AroundPropertyHook first = aroundPropertyHooks.remove(0);
        return HookSupport.wrap(first, HookSupport.combineAroundPropertyHooks(aroundPropertyHooks));
    }

    private static AroundPropertyHook wrap(AroundPropertyHook outer, AroundPropertyHook inner) {
        return (context, property) -> {
            PropertyExecutor innerExecutor = () -> {
                try {
                    return inner.aroundProperty(context, property);
                }
                catch (Throwable throwable) {
                    return (PropertyExecutionResult)JqwikExceptionSupport.throwAsUncheckedException(throwable);
                }
            };
            return outer.aroundProperty(context, innerExecutor);
        };
    }

    public static AroundTryHook combineAroundTryHooks(List<AroundTryHook> aroundTryHooks) {
        if (aroundTryHooks.isEmpty()) {
            return AroundTryHook.BASE;
        }
        aroundTryHooks = new ArrayList<AroundTryHook>(aroundTryHooks);
        AroundTryHook first = aroundTryHooks.remove(0);
        return HookSupport.wrap(first, HookSupport.combineAroundTryHooks(aroundTryHooks));
    }

    private static AroundTryHook wrap(AroundTryHook outer, AroundTryHook inner) {
        return (context, aTry, outerParams) -> {
            TryExecutor innerExecutor = innerParams -> {
                try {
                    return inner.aroundTry(context, aTry, innerParams);
                }
                catch (Throwable throwable) {
                    return (TryExecutionResult)JqwikExceptionSupport.throwAsUncheckedException(throwable);
                }
            };
            return outer.aroundTry(context, innerExecutor, outerParams);
        };
    }

    public static SkipExecutionHook combineSkipExecutionHooks(List<SkipExecutionHook> skipExecutionHooks) {
        if (skipExecutionHooks.isEmpty()) {
            return SkipExecutionHook.DO_NOT_SKIP;
        }
        SkipExecutionHook first = skipExecutionHooks.remove(0);
        return HookSupport.then(first, HookSupport.combineSkipExecutionHooks(skipExecutionHooks));
    }

    private static SkipExecutionHook then(SkipExecutionHook first, SkipExecutionHook rest) {
        return descriptor -> {
            SkipExecutionHook.SkipResult result = first.shouldBeSkipped(descriptor);
            if (result.isSkipped()) {
                return result;
            }
            return rest.shouldBeSkipped(descriptor);
        };
    }

    public static BeforeContainerHook combineBeforeContainerHooks(List<BeforeContainerHook> beforeContainerHooks) {
        return context -> {
            ThrowableCollector throwableCollector = new ThrowableCollector(TestAbortedException.class::isInstance);
            for (BeforeContainerHook hook : beforeContainerHooks) {
                throwableCollector.execute(() -> hook.beforeContainer(context));
            }
            throwableCollector.assertEmpty();
        };
    }

    public static AfterContainerHook combineAfterContainerHooks(List<AfterContainerHook> afterContainerHooks) {
        return context -> {
            ThrowableCollector throwableCollector = new ThrowableCollector(TestAbortedException.class::isInstance);
            for (AfterContainerHook hook : afterContainerHooks) {
                throwableCollector.execute(() -> hook.afterContainer(context));
            }
            throwableCollector.assertEmpty();
        };
    }

    public static ResolveParameterHook combineResolveParameterHooks(List<ResolveParameterHook> resolveParameterHooks) {
        if (resolveParameterHooks.isEmpty()) {
            return ResolveParameterHook.DO_NOT_RESOLVE;
        }
        return new CombinedResolveParameterHook(resolveParameterHooks);
    }
}

