/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.ArrayArbitrary;
import net.jqwik.engine.properties.FeatureExtractor;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.MultivalueArbitraryBase;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableList;

public class DefaultArrayArbitrary<T, A>
extends MultivalueArbitraryBase<T, A>
implements ArrayArbitrary<T, A> {
    private final Class<?> componentClass;

    public static <T, A> ArrayArbitrary<T, A> forArrayType(Arbitrary<T> elementArbitrary, Class<A> arrayClass) {
        if (!arrayClass.isArray()) {
            String message = String.format("<%s> is not an array type.", arrayClass);
            throw new IllegalArgumentException(message);
        }
        return new DefaultArrayArbitrary<T, A>(elementArbitrary, arrayClass.getComponentType());
    }

    public static <T> ArrayArbitrary<T, T[]> forComponentType(Arbitrary<T> elementArbitrary, Class<?> componentType) {
        return new DefaultArrayArbitrary(elementArbitrary, componentType);
    }

    public DefaultArrayArbitrary(Arbitrary<T> elementArbitrary, Class<?> componentClass) {
        super(elementArbitrary);
        this.componentClass = componentClass;
    }

    @Override
    public ArrayArbitrary<T, A> ofMinSize(int minSize) {
        return (ArrayArbitrary)super.ofMinSize(minSize);
    }

    @Override
    public ArrayArbitrary<T, A> ofMaxSize(int maxSize) {
        return (ArrayArbitrary)super.ofMaxSize(maxSize);
    }

    @Override
    public ArrayArbitrary<T, A> withSizeDistribution(RandomDistribution distribution) {
        return (ArrayArbitrary)super.withSizeDistribution(distribution);
    }

    public RandomGenerator<A> generator(int genSize) {
        return this.createListGenerator(genSize, false).map(this::toArray);
    }

    public RandomGenerator<A> generatorWithEmbeddedEdgeCases(int genSize) {
        return this.createListGenerator(genSize, true).map(this::toArray);
    }

    public Optional<ExhaustiveGenerator<A>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.list(this.elementArbitrary, this.minSize, this.maxSize(), this.uniquenessExtractors, maxNumberOfSamples).map(generator -> generator.map(this::toArray));
    }

    public EdgeCases<A> edgeCases(int maxEdgeCases) {
        return EdgeCasesSupport.map(this.edgeCases((elements, minSize1) -> new ShrinkableList(elements, (int)minSize1, this.maxSize(), this.uniquenessExtractors), maxEdgeCases), this::toArray);
    }

    private A toArray(List<T> from) {
        Object array = Array.newInstance(this.componentClass, from.size());
        for (int i = 0; i < from.size(); ++i) {
            Array.set(array, i, from.get(i));
        }
        return (A)array;
    }

    @Override
    protected Iterable<T> toIterable(A array) {
        return () -> Arrays.stream((Object[])array).iterator();
    }

    public ArrayArbitrary<T, A> uniqueElements() {
        return (ArrayArbitrary)this.uniqueElements(FeatureExtractor.identity());
    }

    public ArrayArbitrary<T, A> uniqueElements(Function<T, Object> by) {
        FeatureExtractor featureExtractor = by::apply;
        return (ArrayArbitrary)super.uniqueElements(featureExtractor);
    }
}

