/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.FeatureExtractor;
import net.jqwik.engine.properties.shrinking.ShrinkableContainer;

public class ShrinkableSet<E>
extends ShrinkableContainer<Set<E>, E> {
    public ShrinkableSet(Collection<Shrinkable<E>> elements, int minSize, int maxSize, Collection<FeatureExtractor<E>> uniquenessExtractors) {
        this((List<Shrinkable<E>>)new ArrayList<Shrinkable<E>>(elements), minSize, maxSize, uniquenessExtractors);
    }

    private ShrinkableSet(List<Shrinkable<E>> elements, int minSize, int maxSize, Collection<FeatureExtractor<E>> uniquenessExtractors) {
        super(elements, minSize, maxSize, uniquenessExtractors);
    }

    @Override
    public Stream<Shrinkable<Set<E>>> shrink() {
        return super.shrink().filter(shrinkableSet -> ((Set)shrinkableSet.value()).size() >= this.minSize);
    }

    @Override
    protected boolean hasReallyGrown(Shrinkable<Set<E>> grownShrinkable) {
        return ((Set)grownShrinkable.value()).size() > this.elements.size();
    }

    @Override
    Set<E> createValue(List<Shrinkable<E>> shrinkables) {
        int capacityWithLoadFactor = shrinkables.size() * 4 / 3;
        LinkedHashSet<Object> values = new LinkedHashSet<Object>(capacityWithLoadFactor);
        for (Shrinkable<E> shrinkable : shrinkables) {
            values.add(shrinkable.value());
        }
        return values;
    }

    @Override
    Shrinkable<Set<E>> createShrinkable(List<Shrinkable<E>> shrunkElements) {
        return new ShrinkableSet<E>(shrunkElements, this.minSize, this.maxSize, this.uniquenessExtractors);
    }
}

