/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.state;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.Tuple;
import net.jqwik.api.state.Chain;
import net.jqwik.api.state.ChangeDetector;
import net.jqwik.api.state.Transformation;
import net.jqwik.api.state.Transformer;
import net.jqwik.engine.SourceOfRandomness;
import net.jqwik.engine.properties.state.ShrinkableChainIteration;
import net.jqwik.engine.properties.state.ShrinkableChainShrinker;
import org.jetbrains.annotations.NotNull;
import org.opentest4j.TestAbortedException;

public class ShrinkableChain<T>
implements Shrinkable<Chain<T>> {
    public static final int MAX_TRANSFORMER_TRIES = 1000;
    private final long randomSeed;
    private final Supplier<? extends T> initialSupplier;
    private final Function<Random, Transformation<T>> transformationGenerator;
    private final int maxTransformations;
    private final int genSize;
    private final List<ShrinkableChainIteration<T>> iterations;
    private final Supplier<ChangeDetector<T>> changeDetectorSupplier;

    public ShrinkableChain(long randomSeed, Supplier<? extends T> initialSupplier, Function<Random, Transformation<T>> transformationGenerator, Supplier<ChangeDetector<T>> changeDetectorSupplier, int maxTransformations, int genSize) {
        this(randomSeed, initialSupplier, transformationGenerator, changeDetectorSupplier, maxTransformations, genSize, new ArrayList<ShrinkableChainIteration<T>>());
    }

    private ShrinkableChain(long randomSeed, Supplier<? extends T> initialSupplier, Function<Random, Transformation<T>> transformationGenerator, Supplier<ChangeDetector<T>> changeDetectorSupplier, int maxTransformations, int genSize, List<ShrinkableChainIteration<T>> iterations) {
        this.randomSeed = randomSeed;
        this.initialSupplier = initialSupplier;
        this.transformationGenerator = transformationGenerator;
        this.changeDetectorSupplier = changeDetectorSupplier;
        this.maxTransformations = maxTransformations;
        this.genSize = genSize;
        this.iterations = iterations;
    }

    @NotNull
    public Chain<T> value() {
        return new ChainInstance();
    }

    @NotNull
    public Stream<Shrinkable<Chain<T>>> shrink() {
        return new ShrinkableChainShrinker<T>(this, this.iterations, this.maxTransformations).shrink();
    }

    ShrinkableChain<T> cloneWith(List<ShrinkableChainIteration<T>> shrunkIterations, int newMaxSize) {
        return new ShrinkableChain<T>(this.randomSeed, this.initialSupplier, this.transformationGenerator, this.changeDetectorSupplier, newMaxSize, this.genSize, shrunkIterations);
    }

    @NotNull
    public ShrinkingDistance distance() {
        ArrayList<Object> shrinkablesForDistance = new ArrayList<Object>();
        for (int i = 0; i < this.maxTransformations; ++i) {
            if (i < this.iterations.size()) {
                shrinkablesForDistance.add(this.iterations.get((int)i).shrinkable);
                continue;
            }
            shrinkablesForDistance.add(Shrinkable.unshrinkable(t -> t));
        }
        return ShrinkingDistance.forCollection(shrinkablesForDistance);
    }

    public String toString() {
        return String.format("ShrinkableChain[maxSize=%s, iterations=%s]", this.maxTransformations, this.iterations);
    }

    private boolean isInfinite() {
        return this.maxTransformations < 0;
    }

    private class ChainInstance
    implements Chain<T> {
        private ChainInstance() {
        }

        @NotNull
        public Iterator<T> start() {
            return new ChainIterator(ShrinkableChain.this.initialSupplier.get());
        }

        public int maxTransformations() {
            return ShrinkableChain.this.maxTransformations;
        }

        @NotNull
        public List<String> transformations() {
            return ShrinkableChain.this.iterations.stream().map(i -> i.transformation()).collect(Collectors.toList());
        }

        @NotNull
        public List<Transformer<T>> transformers() {
            return ShrinkableChain.this.iterations.stream().map(i -> i.transformer()).collect(Collectors.toList());
        }
    }

    private class ChainIterator
    implements Iterator<T> {
        private final Random random;
        private int steps;
        private T current;
        private boolean initialSupplied;
        private Transformer<T> nextTransformer;

        private ChainIterator(T initial) {
            this.random = SourceOfRandomness.newRandom(ShrinkableChain.this.randomSeed);
            this.steps = 0;
            this.initialSupplied = false;
            this.nextTransformer = null;
            this.current = initial;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (!this.initialSupplied) {
                return true;
            }
            ShrinkableChain shrinkableChain = ShrinkableChain.this;
            synchronized (shrinkableChain) {
                if (ShrinkableChain.this.isInfinite()) {
                    this.nextTransformer = this.nextTransformer();
                    return !this.nextTransformer.isEndOfChain();
                }
                if (this.steps < ShrinkableChain.this.maxTransformations) {
                    this.nextTransformer = this.nextTransformer();
                    return !this.nextTransformer.isEndOfChain();
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            if (!this.initialSupplied) {
                this.initialSupplied = true;
                return this.current;
            }
            ShrinkableChain shrinkableChain = ShrinkableChain.this;
            synchronized (shrinkableChain) {
                Transformer transformer = this.nextTransformer;
                this.current = this.transformState(transformer, this.current);
                return this.current;
            }
        }

        private Transformer<T> nextTransformer() {
            long nextSeed = this.random.nextLong();
            if (this.steps < ShrinkableChain.this.iterations.size()) {
                return this.rerunStep();
            }
            return this.runNewStep(nextSeed);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T transformState(Transformer<T> transformer, T before) {
            ChangeDetector changeDetector = (ChangeDetector)ShrinkableChain.this.changeDetectorSupplier.get();
            changeDetector.before(before);
            try {
                Object after = transformer.apply(before);
                boolean stateHasChanged = changeDetector.hasChanged(after);
                ShrinkableChainIteration currentIteration = (ShrinkableChainIteration)ShrinkableChain.this.iterations.get(this.steps);
                ShrinkableChain.this.iterations.set(this.steps, currentIteration.withStateChange(stateHasChanged));
                Object object = after;
                return object;
            }
            finally {
                ++this.steps;
            }
        }

        private Transformer<T> rerunStep() {
            ShrinkableChainIteration iteration = (ShrinkableChainIteration)ShrinkableChain.this.iterations.get(this.steps);
            iteration.precondition().ifPresent(predicate -> {
                if (!predicate.test(this.current)) {
                    throw new TestAbortedException("Precondition no longer valid");
                }
            });
            return (Transformer)iteration.shrinkable.value();
        }

        private Transformer<T> runNewStep(long nextSeed) {
            Random random = SourceOfRandomness.newRandom(nextSeed);
            AtomicInteger attemptsCounter = new AtomicInteger(0);
            while (attemptsCounter.get() < 1000) {
                Tuple.Tuple3 arbitraryAccessTuple = this.nextTransformerArbitrary(random, attemptsCounter);
                Arbitrary arbitrary = (Arbitrary)arbitraryAccessTuple.get1();
                Predicate precondition = (Predicate)arbitraryAccessTuple.get2();
                boolean accessState = (Boolean)arbitraryAccessTuple.get3();
                RandomGenerator generator = arbitrary.generator(ShrinkableChain.this.genSize);
                Shrinkable nextShrinkable = generator.next(random);
                Transformer next = (Transformer)nextShrinkable.value();
                if (next == Transformer.noop()) continue;
                ShrinkableChain.this.iterations.add(new ShrinkableChainIteration(precondition, accessState, nextShrinkable));
                return next;
            }
            return (Transformer)this.failWithTooManyAttempts(attemptsCounter);
        }

        private Tuple.Tuple3<Arbitrary<Transformer<T>>, Predicate<T>, Boolean> nextTransformerArbitrary(Random random, AtomicInteger attemptsCounter) {
            AtomicBoolean accessState = new AtomicBoolean(false);
            Supplier<Object> supplier = () -> {
                accessState.set(true);
                return this.current;
            };
            while (attemptsCounter.getAndIncrement() < 1000) {
                boolean hasPrecondition;
                Transformation chainGenerator = (Transformation)ShrinkableChain.this.transformationGenerator.apply(random);
                Predicate precondition = chainGenerator.precondition();
                boolean bl = hasPrecondition = precondition != Transformation.NO_PRECONDITION;
                if (hasPrecondition && !precondition.test(this.current)) continue;
                accessState.set(false);
                Arbitrary arbitrary = (Arbitrary)chainGenerator.apply(supplier);
                return Tuple.of((Object)arbitrary, (Object)(hasPrecondition ? precondition : null), (Object)accessState.get());
            }
            return (Tuple.Tuple3)this.failWithTooManyAttempts(attemptsCounter);
        }

        private <R> R failWithTooManyAttempts(AtomicInteger attemptsCounter) {
            String message = String.format("Could not generate a transformer after %s attempts.", attemptsCounter.get());
            throw new JqwikException(message);
        }
    }
}

