/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.ForAllParametersGenerator;
import net.jqwik.engine.properties.IncompatibleDataException;
import net.jqwik.engine.support.JqwikStringSupport;
import net.jqwik.engine.support.MethodParameter;
import net.jqwik.engine.support.types.TypeUsageImpl;

public class DataBasedShrinkablesGenerator
implements ForAllParametersGenerator {
    private final List<MethodParameter> forAllParameters;
    private final Iterable<? extends Tuple> data;
    private Iterator<? extends Tuple> iterator;

    public DataBasedShrinkablesGenerator(List<MethodParameter> forAllParameters, Iterable<? extends Tuple> data) {
        this.forAllParameters = forAllParameters;
        this.data = data;
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<Shrinkable<Object>> next() {
        Tuple tuple = this.iterator.next();
        this.checkCompatibility(tuple);
        return tuple.items().stream().map(Shrinkable::unshrinkable).collect(Collectors.toList());
    }

    @Override
    public void reset() {
        this.iterator = this.data.iterator();
    }

    private void checkCompatibility(Tuple tuple) {
        if (tuple.size() != this.forAllParameters.size()) {
            throw new IncompatibleDataException(this.createIncompatibilityMessage(tuple));
        }
        for (int i = 0; i < tuple.items().size(); ++i) {
            TypeUsage valueType;
            Object value = tuple.items().get(i);
            TypeUsage parameterType = TypeUsageImpl.forParameter(this.forAllParameters.get(i));
            if (!(value == null ? parameterType.getRawType().isPrimitive() : !(valueType = TypeUsage.of(value.getClass(), (TypeUsage[])new TypeUsage[0])).canBeAssignedTo(parameterType))) continue;
            throw new IncompatibleDataException(this.createIncompatibilityMessage(tuple));
        }
    }

    private String createIncompatibilityMessage(Tuple tuple) {
        List parameterTypes = this.forAllParameters.stream().map(TypeUsageImpl::forParameter).collect(Collectors.toList());
        return String.format("Data tuple %s is not compatible with parameters %s", tuple, JqwikStringSupport.displayString(parameterTypes));
    }
}

