/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.List;
import java.util.stream.Collectors;
import net.jqwik.api.Tuple;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.FromGeneratorsArbitrary;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

public class FrequencyArbitrary<T>
extends FromGeneratorsArbitrary<T> {
    private final List<Tuple.Tuple2<Integer, T>> frequencies;

    public FrequencyArbitrary(List<Tuple.Tuple2<Integer, T>> frequencies) {
        super(RandomGenerators.frequency(frequencies), max -> ExhaustiveGenerators.choose(FrequencyArbitrary.valuesOf(frequencies), (long)max), maxEdgeCases -> EdgeCasesSupport.choose(FrequencyArbitrary.valuesOf(frequencies), maxEdgeCases));
        this.frequencies = frequencies;
    }

    private static <T> List<T> valuesOf(List<Tuple.Tuple2<Integer, T>> frequencies) {
        return frequencies.stream().map(Tuple.Tuple2::get2).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrequencyArbitrary that = (FrequencyArbitrary)o;
        return this.frequencies.equals(that.frequencies);
    }

    public int hashCode() {
        return this.frequencies.hashCode();
    }
}

