/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.shrinking.CollectShrinkable;

public class CollectGenerator<T>
implements RandomGenerator<List<T>> {
    private final RandomGenerator<T> elementGenerator;
    private final Predicate<List<T>> until;

    public CollectGenerator(RandomGenerator<T> elementGenerator, Predicate<List<T>> until) {
        this.elementGenerator = elementGenerator;
        this.until = until;
    }

    public Shrinkable<List<T>> next(Random random) {
        ArrayList<Object> base = new ArrayList<Object>();
        ArrayList shrinkables = new ArrayList();
        for (int i = 0; i < 10000; ++i) {
            if (this.until.test(base)) {
                return new CollectShrinkable(shrinkables, this.until);
            }
            Shrinkable shrinkable = this.elementGenerator.next(random);
            base.add(shrinkable.value());
            shrinkables.add(shrinkable);
        }
        String message = String.format("Generated list not fulfilled condition after maximum of %s elements", 10000);
        throw new JqwikException(message);
    }
}

