/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.JqwikException;
import net.jqwik.api.lifecycle.CannotResolveParameterException;
import net.jqwik.api.lifecycle.ContainerLifecycleContext;
import net.jqwik.api.lifecycle.ProvidePropertyInstanceHook;
import net.jqwik.engine.descriptor.ContainerClassDescriptor;
import net.jqwik.engine.support.JqwikExceptionSupport;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.junit.platform.engine.TestDescriptor;

class TestInstanceCreator {
    private final ContainerLifecycleContext containerLifecycleContext;
    private final Class<?> containerClass;
    private final ContainerClassDescriptor containerDescriptor;
    private final ProvidePropertyInstanceHook providePropertyInstance;

    TestInstanceCreator(ContainerLifecycleContext containerLifecycleContext, ContainerClassDescriptor containerDescriptor, ProvidePropertyInstanceHook providePropertyInstanceHook) {
        this.containerLifecycleContext = containerLifecycleContext;
        this.containerClass = (Class)containerLifecycleContext.optionalContainerClass().orElseThrow(() -> {
            String message = String.format("Container [%s] cannot be instantiated", containerLifecycleContext.label());
            return new JqwikException(message);
        });
        this.containerDescriptor = containerDescriptor;
        this.providePropertyInstance = providePropertyInstanceHook;
    }

    Object create() {
        if (this.providePropertyInstance.equals(ProvidePropertyInstanceHook.DEFAULT)) {
            return this.create(this.containerClass, this.containerDescriptor);
        }
        try {
            return this.providePropertyInstance.provide(this.containerClass);
        }
        catch (Throwable throwable) {
            JqwikExceptionSupport.rethrowIfBlacklisted(throwable);
            String message = String.format("ProvidePropertyInstanceHook [%s] cannot provide instance for class [%s]", this.providePropertyInstance, this.containerClass);
            throw new JqwikException(message, throwable);
        }
    }

    private Object create(Class<?> instanceClass, TestDescriptor descriptor) {
        List<Constructor<?>> constructors = this.allAccessibleConstructors(instanceClass);
        if (constructors.size() == 0) {
            String message = String.format("Test container class [%s] has no accessible constructor", instanceClass.getName());
            throw new JqwikException(message);
        }
        if (constructors.size() > 1) {
            String message = String.format("Test container class [%s] has more than one accessible constructor", instanceClass.getName());
            throw new JqwikException(message);
        }
        Constructor<?> constructor = constructors.get(0);
        return this.newInstance(instanceClass, constructor, descriptor);
    }

    private Object newInstance(Class<?> instanceClass, Constructor<?> constructor, TestDescriptor descriptor) {
        if (JqwikReflectionSupport.isInnerClass(instanceClass)) {
            return this.newInstanceOfInnerContainer(constructor, descriptor);
        }
        return JqwikReflectionSupport.newInstance(constructor, this.resolveParameters(constructor, null));
    }

    private Object newInstanceOfInnerContainer(Constructor<?> constructor, TestDescriptor descriptor) {
        TestDescriptor parentDescriptor = descriptor.getParent().orElse(descriptor);
        ContainerClassDescriptor parentClassDescriptor = (ContainerClassDescriptor)parentDescriptor;
        Class<?> parentClass = parentClassDescriptor.getContainerClass();
        Object parentInstance = this.create(parentClass, parentDescriptor);
        return JqwikReflectionSupport.newInstance(constructor, this.resolveParameters(constructor, parentInstance));
    }

    private List<Constructor<?>> allAccessibleConstructors(Class<?> instanceClass) {
        ArrayList constructors = new ArrayList(Arrays.asList(instanceClass.getConstructors()));
        for (Constructor<?> declaredConstructor : instanceClass.getDeclaredConstructors()) {
            if (constructors.contains(declaredConstructor)) continue;
            constructors.add(declaredConstructor);
        }
        return constructors;
    }

    private Object[] resolveParameters(Constructor<?> constructor, Object parent) {
        Object[] args = new Object[constructor.getParameterCount()];
        for (int i = 0; i < args.length; ++i) {
            int index = i;
            args[index] = index == 0 && parent != null ? parent : this.containerLifecycleContext.resolveParameter(constructor, index).map(parameterSupplier -> parameterSupplier.get(Optional.empty())).orElseThrow(() -> {
                String info = "No matching resolver could be found";
                return new CannotResolveParameterException(constructor.getParameters()[index], info);
            });
        }
        return args;
    }
}

