/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.engine.support.JqwikExceptionSupport;

public class IgnoreExceptionShrinkable<T>
implements Shrinkable<T> {
    private final Shrinkable<T> shrinkable;
    private final Class<? extends Throwable>[] exceptionTypes;

    public IgnoreExceptionShrinkable(Shrinkable<T> shrinkable, Class<? extends Throwable>[] exceptionTypes) {
        this.shrinkable = shrinkable;
        this.exceptionTypes = exceptionTypes;
    }

    public T value() {
        return (T)this.shrinkable.value();
    }

    public Stream<Shrinkable<T>> shrink() {
        return this.shrinkable.shrink().filter(s -> {
            try {
                s.value();
                return true;
            }
            catch (Throwable throwable) {
                if (JqwikExceptionSupport.isInstanceOfAny(throwable, this.exceptionTypes)) {
                    return false;
                }
                throw throwable;
            }
        }).map(shrinkable1 -> new IgnoreExceptionShrinkable<T>(shrinkable1, this.exceptionTypes));
    }

    public ShrinkingDistance distance() {
        return this.shrinkable.distance();
    }
}

