/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.SetArbitrary;
import net.jqwik.api.support.CollectorsSupport;
import net.jqwik.engine.properties.FeatureExtractor;
import net.jqwik.engine.properties.arbitraries.MultivalueArbitraryBase;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableSet;

public class DefaultSetArbitrary<T>
extends MultivalueArbitraryBase<T, Set<T>>
implements SetArbitrary<T> {
    public DefaultSetArbitrary(Arbitrary<T> elementArbitrary) {
        super(elementArbitrary);
        this.uniquenessExtractors.add(FeatureExtractor.identity());
    }

    @Override
    protected Iterable<T> toIterable(Set<T> streamable) {
        return streamable;
    }

    public RandomGenerator<Set<T>> generator(int genSize) {
        return this.rawGenerator(genSize, false);
    }

    public RandomGenerator<Set<T>> generatorWithEmbeddedEdgeCases(int genSize) {
        return this.rawGenerator(genSize, true);
    }

    private RandomGenerator<Set<T>> rawGenerator(int genSize, boolean withEmbeddedEdgeCases) {
        RandomGenerator elementGenerator = this.elementGenerator(this.elementArbitrary, genSize, withEmbeddedEdgeCases);
        return RandomGenerators.set(elementGenerator, this.minSize, this.maxSize(), genSize, this.sizeDistribution, this.uniquenessExtractors, this.elementArbitrary);
    }

    public Optional<ExhaustiveGenerator<Set<T>>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.set(this.elementArbitrary, this.minSize, this.maxSize(), this.uniquenessExtractors, maxNumberOfSamples);
    }

    public EdgeCases<Set<T>> edgeCases(int maxEdgeCases) {
        return this.edgeCases((elementList, minSize1) -> {
            LinkedHashSet elementSet = new LinkedHashSet(elementList);
            return new ShrinkableSet(elementSet, (int)minSize1, this.maxSize(), this.uniquenessExtractors, this.elementArbitrary);
        }, maxEdgeCases);
    }

    public SetArbitrary<T> ofMaxSize(int maxSize) {
        return (SetArbitrary)super.ofMaxSize(maxSize);
    }

    public SetArbitrary<T> ofMinSize(int minSize) {
        return (SetArbitrary)super.ofMinSize(minSize);
    }

    public SetArbitrary<T> withSizeDistribution(RandomDistribution distribution) {
        return (SetArbitrary)super.withSizeDistribution(distribution);
    }

    public <U> Arbitrary<Set<U>> mapEach(BiFunction<Set<T>, T, U> mapper) {
        return this.map(elements -> (Set)elements.stream().map(e -> mapper.apply((Set)elements, (Object)e)).collect(CollectorsSupport.toLinkedHashSet()));
    }

    public <U> Arbitrary<Set<U>> flatMapEach(BiFunction<Set<T>, T, Arbitrary<U>> flatMapper) {
        return this.flatMap(elements -> {
            List arbitraries = elements.stream().map(e -> (Arbitrary)flatMapper.apply((Set)elements, (Object)e)).collect(Collectors.toList());
            return Combinators.combine(arbitraries).as(LinkedHashSet::new);
        });
    }

    public SetArbitrary<T> uniqueElements() {
        return this;
    }

    public SetArbitrary<T> uniqueElements(Function<T, Object> by) {
        FeatureExtractor featureExtractor = by::apply;
        return (SetArbitrary)super.uniqueElements(featureExtractor);
    }
}

