/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.support.HashCodeSupport;
import net.jqwik.api.support.LambdaSupport;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.arbitraries.DecimalEdgeCasesConfiguration;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomDecimalGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableBigInteger;

class DecimalGeneratingArbitrary
extends TypedCloneable
implements Arbitrary<BigDecimal> {
    private static final int DEFAULT_SCALE = 2;
    Range<BigDecimal> range;
    int scale = 2;
    BigDecimal shrinkingTarget;
    RandomDistribution distribution = RandomDistribution.biased();
    private Consumer<EdgeCases.Config<BigDecimal>> edgeCasesConfigurator = EdgeCases.Config.noConfig();

    DecimalGeneratingArbitrary(Range<BigDecimal> defaultRange) {
        this.range = defaultRange;
        this.shrinkingTarget = null;
    }

    public RandomGenerator<BigDecimal> generator(int genSize) {
        this.checkRange();
        return RandomDecimalGenerators.bigDecimals(genSize, this.range, this.scale, this.distribution, this.shrinkingTarget());
    }

    private void checkRange() {
        this.checkScale((BigDecimal)this.range.min);
        this.checkScale((BigDecimal)this.range.max);
    }

    private void checkScale(BigDecimal value) {
        try {
            value.setScale(this.scale);
        }
        catch (ArithmeticException arithmeticException) {
            String message = String.format("Decimal value %s cannot be represented with scale %s.%nYou may want to use a higher scale", value, this.scale);
            throw new JqwikException(message);
        }
    }

    public Optional<ExhaustiveGenerator<BigDecimal>> exhaustive(long maxNumberOfSamples) {
        if (this.range.isSingular()) {
            return ExhaustiveGenerators.choose(Collections.singletonList((BigDecimal)this.range.min), maxNumberOfSamples);
        }
        return Optional.empty();
    }

    public EdgeCases<BigDecimal> edgeCases(int maxEdgeCases) {
        Function edgeCasesCreator = max -> EdgeCasesSupport.fromShrinkables(this.edgeCaseShrinkables((int)max));
        DecimalEdgeCasesConfiguration configuration = new DecimalEdgeCasesConfiguration(this.range, this.scale, this.shrinkingTarget());
        return configuration.configure(this.edgeCasesConfigurator, edgeCasesCreator, maxEdgeCases);
    }

    public Arbitrary<BigDecimal> edgeCases(Consumer<EdgeCases.Config<BigDecimal>> configurator) {
        DecimalGeneratingArbitrary clone = (DecimalGeneratingArbitrary)this.typedClone();
        clone.edgeCasesConfigurator = configurator;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalGeneratingArbitrary that = (DecimalGeneratingArbitrary)o;
        if (this.scale != that.scale) {
            return false;
        }
        if (!this.range.equals(that.range)) {
            return false;
        }
        if (!Objects.equals(this.shrinkingTarget, that.shrinkingTarget)) {
            return false;
        }
        if (!Objects.equals(this.distribution, that.distribution)) {
            return false;
        }
        return LambdaSupport.areEqual(this.edgeCasesConfigurator, that.edgeCasesConfigurator);
    }

    public int hashCode() {
        return HashCodeSupport.hash(this.range, (Object)this.scale, (Object)this.shrinkingTarget);
    }

    private List<Shrinkable<BigDecimal>> edgeCaseShrinkables(int maxEdgeCases) {
        Range<BigInteger> bigIntegerRange = RandomDecimalGenerators.unscaledBigIntegerRange(this.range, this.scale);
        return this.streamRawEdgeCases().filter(aDecimal -> this.range.includes((BigDecimal)aDecimal)).map(value -> {
            BigInteger bigIntegerValue = RandomDecimalGenerators.unscaledBigInteger(value, this.scale);
            BigInteger shrinkingTarget = RandomDecimalGenerators.unscaledBigInteger(this.shrinkingTarget(), this.scale);
            return new ShrinkableBigInteger(bigIntegerValue, bigIntegerRange, shrinkingTarget);
        }).map(shrinkableBigInteger -> shrinkableBigInteger.map(bigInteger -> RandomDecimalGenerators.scaledBigDecimal(bigInteger, this.scale))).limit(Math.max(0, maxEdgeCases)).collect(Collectors.toList());
    }

    private Stream<BigDecimal> streamRawEdgeCases() {
        BigDecimal smallest = BigDecimal.ONE.movePointLeft(this.scale);
        BigDecimal minBorder = this.range.minIncluded ? (BigDecimal)this.range.min : ((BigDecimal)this.range.min).add(smallest);
        BigDecimal maxBorder = this.range.maxIncluded ? (BigDecimal)this.range.max : ((BigDecimal)this.range.max).subtract(smallest);
        BigDecimal[] literalEdgeCases = new BigDecimal[]{BigDecimal.ZERO.movePointLeft(this.scale), BigDecimal.ONE, BigDecimal.ONE.negate(), smallest, smallest.negate(), minBorder, maxBorder};
        if (this.shrinkingTarget == null) {
            return Arrays.stream(literalEdgeCases);
        }
        return Stream.concat(Stream.of(this.shrinkingTarget, this.shrinkingTarget.add(smallest), this.shrinkingTarget.subtract(smallest)), Arrays.stream(literalEdgeCases));
    }

    private BigDecimal shrinkingTarget() {
        if (this.shrinkingTarget == null) {
            return RandomDecimalGenerators.defaultShrinkingTarget(this.range, this.scale);
        }
        return this.shrinkingTarget;
    }
}

