/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.domains.DomainContextBase;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.junit.platform.commons.support.ReflectionSupport;

public class DomainContextBaseConfigurators {
    private static final Logger LOG = Logger.getLogger(DomainContextBaseConfigurators.class.getName());

    public static Collection<ArbitraryConfigurator> forContextBase(DomainContextBase base) {
        return Stream.concat(DomainContextBaseConfigurators.configuratorsFromInnerClasses(base), DomainContextBaseConfigurators.configuratorsFromBaseItself(base)).collect(Collectors.toList());
    }

    private static Stream<ArbitraryConfigurator> configuratorsFromInnerClasses(DomainContextBase base) {
        Predicate<Class> implementsArbitraryConfigurator = clazz -> ArbitraryConfigurator.class.isAssignableFrom((Class<?>)clazz) && !JqwikReflectionSupport.isPrivate(clazz);
        List arbitraryProviderClasses = ReflectionSupport.findNestedClasses(base.getClass(), implementsArbitraryConfigurator);
        DomainContextBaseConfigurators.warnIfClassesHaveNoFittingConstructor(arbitraryProviderClasses);
        return arbitraryProviderClasses.stream().filter(DomainContextBaseConfigurators::hasFittingConstructor).map(clazz -> DomainContextBaseConfigurators.createArbitraryConfigurator(clazz, base));
    }

    private static Stream<ArbitraryConfigurator> configuratorsFromBaseItself(DomainContextBase base) {
        if (base instanceof ArbitraryConfigurator) {
            return Stream.of((ArbitraryConfigurator)base);
        }
        return Stream.empty();
    }

    private static void warnIfClassesHaveNoFittingConstructor(List<Class<?>> classes) {
        classes.stream().filter(aClass -> !DomainContextBaseConfigurators.hasFittingConstructor(aClass)).forEach(aClass -> {
            String message = String.format("Class <%s> does not have a default constructor and cannot be instantiated as %s.", aClass.getName(), ArbitraryConfigurator.class);
            LOG.warning(message);
        });
    }

    private static boolean hasFittingConstructor(Class<?> clazz) {
        if (JqwikReflectionSupport.isStatic(clazz)) {
            return JqwikReflectionSupport.hasDefaultConstructor(clazz);
        }
        return JqwikReflectionSupport.hasConstructor(clazz, clazz.getDeclaringClass());
    }

    private static ArbitraryConfigurator createArbitraryConfigurator(Class<?> clazz, DomainContextBase base) {
        return (ArbitraryConfigurator)JqwikReflectionSupport.newInstanceInTestContext(clazz, base);
    }
}

