/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.Optional;
import java.util.function.Function;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.support.HashCodeSupport;
import net.jqwik.api.support.LambdaSupport;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;

public class ArbitraryFlatMap<T, U>
implements Arbitrary<U> {
    private final Arbitrary<T> self;
    private final Function<T, Arbitrary<U>> mapper;

    public ArbitraryFlatMap(Arbitrary<T> self, Function<T, Arbitrary<U>> mapper) {
        this.self = self;
        this.mapper = mapper;
    }

    public RandomGenerator<U> generator(int genSize) {
        return this.self.generator(genSize).flatMap(this.mapper, genSize, false);
    }

    public RandomGenerator<U> generatorWithEmbeddedEdgeCases(int genSize) {
        return this.self.generatorWithEmbeddedEdgeCases(genSize).flatMap(this.mapper, genSize, true);
    }

    public Optional<ExhaustiveGenerator<U>> exhaustive(long maxNumberOfSamples) {
        return this.self.exhaustive(maxNumberOfSamples).flatMap(generator -> ExhaustiveGenerators.flatMap(generator, this.mapper, maxNumberOfSamples));
    }

    public EdgeCases<U> edgeCases(int maxEdgeCases) {
        return EdgeCasesSupport.flatMapArbitrary(this.self.edgeCases(maxEdgeCases), this.mapper, maxEdgeCases);
    }

    public boolean isGeneratorMemoizable() {
        return this.self.isGeneratorMemoizable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArbitraryFlatMap that = (ArbitraryFlatMap)o;
        if (!this.self.equals(that.self)) {
            return false;
        }
        return LambdaSupport.areEqual(this.mapper, that.mapper);
    }

    public int hashCode() {
        return HashCodeSupport.hash(this.self, this.mapper.getClass());
    }
}

