/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Tuple;
import net.jqwik.engine.support.JqwikStringSupport;

public class ChooseRandomlyByFrequency<T>
implements Function<Random, T> {
    private int[] upperBounds;
    private int size = 0;
    private List<T> valuesToChooseFrom;

    public ChooseRandomlyByFrequency(List<Tuple.Tuple2<Integer, T>> frequencies) {
        this.calculateUpperBorders(frequencies);
        if (this.size <= 0) {
            throw new JqwikException(String.format("%s does not contain any positive frequencies.", JqwikStringSupport.displayString(frequencies)));
        }
    }

    protected List<T> possibleValues() {
        return this.valuesToChooseFrom;
    }

    private void calculateUpperBorders(List<Tuple.Tuple2<Integer, T>> frequencies) {
        ArrayList<T> values = new ArrayList<T>(frequencies.size());
        ArrayList<Integer> upperBounds = new ArrayList<Integer>(frequencies.size());
        for (Tuple.Tuple2<Integer, T> tuple : frequencies) {
            int frequency = (Integer)tuple.get1();
            if (frequency <= 0) continue;
            this.size = Math.addExact(this.size, frequency);
            Object value = tuple.get2();
            values.add(value);
            upperBounds.add(this.size);
        }
        this.valuesToChooseFrom = values;
        this.upperBounds = upperBounds.stream().mapToInt(i -> i).toArray();
    }

    private T choose(int index) {
        int i = Arrays.binarySearch(this.upperBounds, index);
        i = i < 0 ? -(i + 1) : ++i;
        return this.valuesToChooseFrom.get(i);
    }

    @Override
    public T apply(Random random) {
        return this.choose(random.nextInt(this.size));
    }
}

