/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.facades;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.Store;
import net.jqwik.engine.support.LruCache;

public class Memoize {
    private static Store<Map<Tuple.Tuple3<Arbitrary<?>, Integer, Boolean>, RandomGenerator<?>>> generatorStore() {
        return Store.getOrCreate(Memoize.class, (Lifespan)Lifespan.PROPERTY, () -> new LruCache(500));
    }

    public static <U> RandomGenerator<U> memoizedGenerator(Arbitrary<? extends U> arbitrary, int genSize, boolean withEdgeCases, Supplier<RandomGenerator<? extends U>> generatorSupplier) {
        if (!arbitrary.isGeneratorMemoizable()) {
            return generatorSupplier.get();
        }
        Tuple.Tuple3 key = Tuple.of(arbitrary, (Object)genSize, (Object)withEdgeCases);
        RandomGenerator generator = Memoize.computeIfAbsent((Map)Memoize.generatorStore().get(), key, ignore -> (RandomGenerator)generatorSupplier.get());
        return generator;
    }

    private static <K, V> V computeIfAbsent(Map<K, V> cache, K key, Function<? super K, ? extends V> mappingFunction) {
        V result = cache.get(key);
        if (result == null) {
            result = mappingFunction.apply(key);
            cache.put(key, result);
        }
        return result;
    }
}

