/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.SampleReportingFormat;
import net.jqwik.api.domains.DomainContextBase;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.junit.platform.commons.support.ReflectionSupport;

public class DomainContextBaseReportingFormats {
    private static final Logger LOG = Logger.getLogger(DomainContextBaseReportingFormats.class.getName());

    public static Collection<SampleReportingFormat> forContextBase(DomainContextBase base) {
        return Stream.concat(DomainContextBaseReportingFormats.formatsFromInnerClasses(base), DomainContextBaseReportingFormats.formatsFromBaseItself(base)).collect(Collectors.toList());
    }

    private static Stream<SampleReportingFormat> formatsFromInnerClasses(DomainContextBase base) {
        Predicate<Class> implementsReportingFormat = clazz -> SampleReportingFormat.class.isAssignableFrom((Class<?>)clazz) && !JqwikReflectionSupport.isPrivate(clazz);
        List reportingFormatClasses = ReflectionSupport.findNestedClasses(base.getClass(), implementsReportingFormat);
        DomainContextBaseReportingFormats.warnIfClassesHaveNoFittingConstructor(reportingFormatClasses);
        return reportingFormatClasses.stream().filter(DomainContextBaseReportingFormats::hasFittingConstructor).map(clazz -> DomainContextBaseReportingFormats.createArbitraryConfigurator(clazz, base));
    }

    private static Stream<SampleReportingFormat> formatsFromBaseItself(DomainContextBase base) {
        if (base instanceof SampleReportingFormat) {
            return Stream.of((SampleReportingFormat)base);
        }
        return Stream.empty();
    }

    private static void warnIfClassesHaveNoFittingConstructor(List<Class<?>> classes) {
        classes.stream().filter(aClass -> !DomainContextBaseReportingFormats.hasFittingConstructor(aClass)).forEach(aClass -> {
            String message = String.format("Class <%s> does not have a default constructor and cannot be instantiated as %s.", aClass.getName(), SampleReportingFormat.class);
            LOG.warning(message);
        });
    }

    private static boolean hasFittingConstructor(Class<?> clazz) {
        if (JqwikReflectionSupport.isStatic(clazz)) {
            return JqwikReflectionSupport.hasDefaultConstructor(clazz);
        }
        return JqwikReflectionSupport.hasConstructor(clazz, clazz.getDeclaringClass());
    }

    private static SampleReportingFormat createArbitraryConfigurator(Class<?> clazz, DomainContextBase base) {
        return (SampleReportingFormat)JqwikReflectionSupport.newInstanceInTestContext(clazz, base);
    }
}

