/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.api.lifecycle.TryLifecycleContext;
import net.jqwik.engine.execution.ParametersGenerator;
import net.jqwik.engine.properties.shrinking.ShrunkSampleRecreator;
import org.jspecify.annotations.Nullable;

public class GenerationInfo
implements Serializable {
    public static final GenerationInfo NULL = new GenerationInfo(null);
    private final @Nullable String randomSeed;
    private final int generationIndex;
    private final List<List<Byte>> byteSequences;

    public GenerationInfo(@Nullable String randomSeed) {
        this(randomSeed, 0);
    }

    public GenerationInfo(@Nullable String randomSeed, int generationIndex) {
        this(randomSeed, generationIndex, Collections.emptyList());
    }

    private GenerationInfo(@Nullable String randomSeed, int generationIndex, List<List<Byte>> byteSequences) {
        this.randomSeed = randomSeed != null ? (randomSeed.isEmpty() ? null : randomSeed) : null;
        this.generationIndex = generationIndex;
        this.byteSequences = byteSequences;
    }

    private List<Byte> toByteSequence(List<TryExecutionResult.Status> shrinkingSequence) {
        return shrinkingSequence.stream().map(status -> (byte)status.ordinal()).collect(Collectors.toList());
    }

    public GenerationInfo appendShrinkingSequence(List<TryExecutionResult.Status> toAppend) {
        if (toAppend.isEmpty()) {
            return this;
        }
        ArrayList<List<Byte>> newByteSequences = new ArrayList<List<Byte>>(this.byteSequences);
        newByteSequences.add(this.toByteSequence(toAppend));
        return new GenerationInfo(this.randomSeed, this.generationIndex, newByteSequences);
    }

    public Optional<String> randomSeed() {
        return Optional.ofNullable(this.randomSeed);
    }

    public int generationIndex() {
        return this.generationIndex;
    }

    public Optional<List<Shrinkable<Object>>> generateOn(ParametersGenerator generator, TryLifecycleContext context) {
        List<Shrinkable<Object>> sample = this.useGenerationIndex(generator, context);
        return this.useShrinkingSequences(sample);
    }

    private Optional<List<Shrinkable<Object>>> useShrinkingSequences(@Nullable List<Shrinkable<Object>> sample) {
        Optional<List<Shrinkable<Object>>> shrunkSample = Optional.ofNullable(sample);
        for (List<TryExecutionResult.Status> shrinkingSequence : this.shrinkingSequences()) {
            if (!shrunkSample.isPresent()) break;
            shrunkSample = this.shrink(shrunkSample.get(), shrinkingSequence);
        }
        return shrunkSample;
    }

    private Optional<List<Shrinkable<Object>>> shrink(List<Shrinkable<Object>> sample, List<TryExecutionResult.Status> shrinkingSequence) {
        ShrunkSampleRecreator recreator = new ShrunkSampleRecreator(sample);
        return recreator.recreateFrom(shrinkingSequence);
    }

    private @Nullable List<Shrinkable<Object>> useGenerationIndex(ParametersGenerator generator, TryLifecycleContext context) {
        List<Shrinkable<Object>> sample = null;
        for (int i = 0; i < this.generationIndex; ++i) {
            if (!generator.hasNext()) {
                return null;
            }
            sample = generator.next(context);
        }
        return sample;
    }

    public List<List<TryExecutionResult.Status>> shrinkingSequences() {
        return this.byteSequences.stream().map(this::toShrinkingSequence).collect(Collectors.toList());
    }

    private List<TryExecutionResult.Status> toShrinkingSequence(List<Byte> sequence) {
        return sequence.stream().map(ordinal -> TryExecutionResult.Status.values()[ordinal]).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenerationInfo that = (GenerationInfo)o;
        if (this.generationIndex != that.generationIndex) {
            return false;
        }
        if (!Objects.equals(this.randomSeed, that.randomSeed)) {
            return false;
        }
        return this.byteSequences.equals(that.byteSequences);
    }

    public int hashCode() {
        int result = this.randomSeed != null ? this.randomSeed.hashCode() : 0;
        result = 31 * result + this.generationIndex;
        return result;
    }

    public String toString() {
        List sizes = this.byteSequences.stream().map(bytes -> "size=" + bytes.size()).collect(Collectors.toList());
        Tuple.Tuple3 tuple = Tuple.of((Object)this.randomSeed, (Object)this.generationIndex, sizes);
        return String.format("GenerationInfo%s", tuple);
    }
}

