/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.hooks.lifecycle;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.AroundTryHook;
import net.jqwik.api.lifecycle.BeforeTry;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.PropagationMode;
import net.jqwik.api.lifecycle.Store;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.api.lifecycle.TryExecutor;
import net.jqwik.api.lifecycle.TryLifecycleContext;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class BeforeTryMembersHook
implements AroundTryHook {
    private static List<Field> findBeforeTryFields(Class<?> testClass) {
        Predicate<Field> isAnnotated = method -> AnnotationSupport.isAnnotated((AnnotatedElement)method, BeforeTry.class);
        return JqwikReflectionSupport.findFieldsPotentiallyOuter(testClass, isAnnotated, HierarchyTraversalMode.TOP_DOWN);
    }

    private void beforeTry(TryLifecycleContext context) {
        List<Field> beforeTryFields = BeforeTryMembersHook.findBeforeTryFields(context.containerClass());
        this.initializeFields(beforeTryFields, context);
    }

    private void initializeFields(List<Field> fields, TryLifecycleContext context) {
        List testInstances = context.testInstances();
        ThrowableCollector throwableCollector = new ThrowableCollector(ignore -> false);
        for (Field field : fields) {
            if (JqwikReflectionSupport.isStatic(field)) {
                String message = String.format("Static field <%s> must not be annotated with @BeforeTry.", field);
                throw new JqwikException(message);
            }
            throwableCollector.execute(() -> this.initializeField(field, testInstances));
        }
        throwableCollector.assertEmpty();
    }

    private void initializeField(Field field, List<Object> testInstances) {
        Store initialFieldValue = Store.getOrCreate((Object)Tuple.of(BeforeTryMembersHook.class, (Object)field), (Lifespan)Lifespan.PROPERTY, () -> JqwikReflectionSupport.readFieldOnContainer(field, testInstances));
        JqwikReflectionSupport.setFieldOnContainer(field, initialFieldValue.get(), testInstances);
    }

    public PropagationMode propagateTo() {
        return PropagationMode.ALL_DESCENDANTS;
    }

    public boolean appliesTo(Optional<AnnotatedElement> element) {
        return element.map(e -> e instanceof Method).orElse(false);
    }

    public int aroundTryProximity() {
        return -100;
    }

    public TryExecutionResult aroundTry(TryLifecycleContext context, TryExecutor aTry, List<Object> parameters) {
        this.beforeTry(context);
        return aTry.execute(parameters);
    }
}

