/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.CannotFindArbitraryException;
import net.jqwik.api.ForAll;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Provide;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.api.support.CollectorsSupport;
import net.jqwik.engine.support.JqwikReflectionSupport;
import net.jqwik.engine.support.MethodParameter;
import net.jqwik.engine.support.OverriddenMethodAnnotationSupport;
import net.jqwik.engine.support.types.TypeUsageImpl;

class ProviderMethod {
    private final Class<? extends Throwable>[] ignoreExceptions;
    private final Method method;
    private final TypeUsage targetType;
    private final List<Object> instances;
    private final ArbitraryProvider.SubtypeProvider subtypeProvider;

    static ProviderMethod forMethod(Method method, TypeUsage targetType, List<Object> instances, ArbitraryProvider.SubtypeProvider subtypeProvider) {
        Class[] ignoreExceptions = OverriddenMethodAnnotationSupport.findDeclaredOrInheritedAnnotation(method, Provide.class).map(Provide::ignoreExceptions).orElse(new Class[0]);
        return new ProviderMethod(method, targetType, instances, subtypeProvider, ignoreExceptions);
    }

    private ProviderMethod(Method underlyingMethod, TypeUsage targetType, List<Object> instances, ArbitraryProvider.SubtypeProvider subtypeProvider, Class<? extends Throwable>[] ignoreExceptions) {
        this.method = underlyingMethod;
        this.targetType = targetType;
        this.instances = instances;
        this.subtypeProvider = subtypeProvider;
        this.ignoreExceptions = ignoreExceptions;
    }

    Set<Arbitrary<?>> invoke() {
        Class<?> containerClass = this.contextInstance().getClass();
        List<MethodParameter> parameters = JqwikReflectionSupport.getMethodParameters(this.method, containerClass);
        Set<Function<List<Object>, Arbitrary<?>>> baseInvoker = Collections.singleton(this::invokeProviderMethod);
        Set<Supplier<Arbitrary<?>>> suppliers = this.arbitrarySuppliers(baseInvoker, parameters, Collections.emptyList());
        return this.mapSet(suppliers, arbitrarySupplier -> ((Arbitrary)arbitrarySupplier.get()).ignoreExceptions((Class[])this.ignoreExceptions));
    }

    private Object contextInstance() {
        return this.instances.get(this.instances.size() - 1);
    }

    private Arbitrary<?> invokeProviderMethod(List<Object> argList) {
        return (Arbitrary)JqwikReflectionSupport.invokeMethodOnContainer(this.method, this.instances, argList.toArray());
    }

    private Set<Supplier<Arbitrary<?>>> arbitrarySuppliers(Set<Function<List<Object>, Arbitrary<?>>> invokers, List<MethodParameter> unresolvedParameters, List<Object> args) {
        if (unresolvedParameters.isEmpty()) {
            return this.mapSet(invokers, invoker -> () -> (Arbitrary)invoker.apply(args));
        }
        ArrayList<MethodParameter> newUnresolvedParameters = new ArrayList<MethodParameter>(unresolvedParameters);
        MethodParameter toResolve = (MethodParameter)newUnresolvedParameters.remove(0);
        if (this.isForAllParameter(toResolve)) {
            ArrayList<Object> newArgs = new ArrayList<Object>(args);
            newArgs.add(this.arbitraryFor(toResolve));
            Set<Function<List<Object>, Arbitrary<?>>> newInvokers = this.flatMapArbitraryInInvocations(invokers, toResolve.getIndex());
            return this.arbitrarySuppliers(newInvokers, newUnresolvedParameters, newArgs);
        }
        ArrayList<Object> newArgs = new ArrayList<Object>(args);
        newArgs.add(this.resolvePlainParameter(toResolve.getRawParameter()));
        return this.arbitrarySuppliers(invokers, newUnresolvedParameters, newArgs);
    }

    private Set<Function<List<Object>, Arbitrary<?>>> flatMapArbitraryInInvocations(Set<Function<List<Object>, Arbitrary<?>>> invokers, int position) {
        Function<Function, Function> mapper = invoker -> arguments -> {
            Arbitrary a = (Arbitrary)arguments.get(position);
            return a.flatMap(argument -> {
                ArrayList<Object> resolved = new ArrayList<Object>((Collection<Object>)arguments);
                resolved.set(position, argument);
                return (Arbitrary)invoker.apply(resolved);
            });
        };
        return this.mapSet(invokers, mapper);
    }

    private Arbitrary<?> arbitraryFor(MethodParameter toResolve) {
        TypeUsage parameterType = TypeUsageImpl.forParameter(toResolve);
        Optional optionalArbitrary = this.subtypeProvider.provideOneFor(parameterType);
        return (Arbitrary)optionalArbitrary.orElseThrow(() -> new CannotFindArbitraryException(parameterType, (ForAll)parameterType.findAnnotation(ForAll.class).orElse(null), this.method));
    }

    private <T, R> Set<R> mapSet(Set<T> invokers, Function<T, R> mapper) {
        return (Set)invokers.stream().map(mapper).collect(CollectorsSupport.toLinkedHashSet());
    }

    private boolean isForAllParameter(MethodParameter parameter) {
        return parameter.isAnnotated(ForAll.class);
    }

    protected Object resolvePlainParameter(Parameter parameter) {
        if (parameter.getType().isAssignableFrom(TypeUsage.class)) {
            return this.targetType;
        }
        String message = String.format("Parameter [%s] cannot be resolved in @Provide method [%s].%nMaybe you want to add annotation `@ForAll`?", parameter, this.method);
        throw new JqwikException(message);
    }
}

