/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.stateful;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.stateful.Action;
import net.jqwik.api.stateful.ActionSequence;
import net.jqwik.engine.properties.stateful.ActionGenerator;
import net.jqwik.engine.properties.stateful.ComprehensiveSizeOfListShrinker;
import net.jqwik.engine.properties.stateful.SequentialActionSequence;
import net.jqwik.engine.properties.stateful.ShrinkablesActionGenerator;
import net.jqwik.engine.support.JqwikStreamSupport;
import org.jspecify.annotations.Nullable;

class ShrinkableActionSequence<T>
implements Shrinkable<ActionSequence<T>> {
    private final ActionGenerator<T> actionGenerator;
    private final int maxSize;
    private final ShrinkingDistance distance;
    private @Nullable SequentialActionSequence<T> generatedSequence = null;

    ShrinkableActionSequence(ActionGenerator<T> actionGenerator, int maxSize, ShrinkingDistance distance) {
        this.actionGenerator = actionGenerator;
        this.maxSize = maxSize;
        this.distance = distance;
    }

    public ActionSequence<T> value() {
        if (this.generatedSequence == null) {
            this.generatedSequence = new SequentialActionSequence<T>(this.actionGenerator, this.maxSize);
        }
        return this.generatedSequence;
    }

    public Stream<Shrinkable<ActionSequence<T>>> shrink() {
        if (this.generatedSequence == null) {
            return Stream.empty();
        }
        return JqwikStreamSupport.concat(this.shrinkSequenceOfActions(), this.shrinkActionsOneAfterTheOther());
    }

    private Stream<Shrinkable<ActionSequence<T>>> shrinkSequenceOfActions() {
        return new ComprehensiveSizeOfListShrinker().shrink(this.actionGenerator.generated(), 1).map(this::createShrinkableActionSequence);
    }

    private Stream<Shrinkable<ActionSequence<T>>> shrinkActionsOneAfterTheOther() {
        List<Shrinkable<Action<T>>> shrinkableActions = this.actionGenerator.generated();
        ArrayList shrinkPerElementStreams = new ArrayList();
        for (int i = 0; i < shrinkableActions.size(); ++i) {
            int index = i;
            Shrinkable<Action<T>> element = shrinkableActions.get(i);
            Stream shrinkElement = element.shrink().flatMap(shrunkElement -> {
                ArrayList<Shrinkable<Action<T>>> actionsCopy = new ArrayList<Shrinkable<Action<T>>>(shrinkableActions);
                actionsCopy.set(index, (Shrinkable<Action<T>>)shrunkElement);
                return Stream.of(this.createShrinkableActionSequence(actionsCopy));
            });
            shrinkPerElementStreams.add(shrinkElement);
        }
        return JqwikStreamSupport.concat(shrinkPerElementStreams);
    }

    private ShrinkableActionSequence<T> createShrinkableActionSequence(List<Shrinkable<Action<T>>> list) {
        ShrinkablesActionGenerator<T> newGenerator = new ShrinkablesActionGenerator<T>(list);
        ShrinkingDistance newDistance = ShrinkingDistance.forCollection(list);
        return new ShrinkableActionSequence<T>(newGenerator, list.size(), newDistance);
    }

    public ShrinkingDistance distance() {
        if (this.generatedSequence == null) {
            return this.distance;
        }
        return ShrinkingDistance.forCollection(this.actionGenerator.generated());
    }
}

