/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

final class StreamConcatenation {
    private StreamConcatenation() {
        throw new AssertionError((Object)"This class cannot be instantiated");
    }

    @SafeVarargs
    public static <T> Stream<T> concat(Stream<? extends T> ... streams) {
        return (Stream)StreamConcatenation.concatInternal((BaseStream[])streams, Spliterator[]::new, BaseStream::spliterator, ConcatSpliterator.OfRef::new, StreamSupport::stream);
    }

    public static IntStream concat(IntStream ... streams) {
        return (IntStream)StreamConcatenation.concatInternal((BaseStream[])streams, Spliterator.OfInt[]::new, IntStream::spliterator, ConcatSpliterator.OfInt::new, StreamSupport::intStream);
    }

    public static LongStream concat(LongStream ... streams) {
        return (LongStream)StreamConcatenation.concatInternal((BaseStream[])streams, Spliterator.OfLong[]::new, LongStream::spliterator, ConcatSpliterator.OfLong::new, StreamSupport::longStream);
    }

    public static DoubleStream concat(DoubleStream ... streams) {
        return (DoubleStream)StreamConcatenation.concatInternal((BaseStream[])streams, Spliterator.OfDouble[]::new, DoubleStream::spliterator, ConcatSpliterator.OfDouble::new, StreamSupport::doubleStream);
    }

    private static <T, T_SPLITR extends Spliterator<T>, T_STREAM extends BaseStream<T, T_STREAM>> T_STREAM concatInternal(T_STREAM[] streams, IntFunction<T_SPLITR[]> arrayFunction, Function<T_STREAM, T_SPLITR> spliteratorFunction, Function<T_SPLITR[], T_SPLITR> concatFunction, BiFunction<T_SPLITR, Boolean, T_STREAM> streamFunction) {
        Spliterator[] spliterators = (Spliterator[])arrayFunction.apply(streams.length);
        boolean parallel = false;
        for (int i = 0; i < streams.length; ++i) {
            Spliterator inSpliterator;
            T_STREAM inStream = streams[i];
            spliterators[i] = inSpliterator = (Spliterator)spliteratorFunction.apply(inStream);
            parallel = parallel || inStream.isParallel();
        }
        Spliterator outSpliterator = (Spliterator)concatFunction.apply(spliterators);
        BaseStream outStream = (BaseStream)streamFunction.apply(outSpliterator, parallel);
        return (T_STREAM)outStream.onClose(new ComposedClose((BaseStream<?, ?>[])streams));
    }

    static final class ComposedClose
    implements Runnable {
        final BaseStream<?, ?>[] streams;

        ComposedClose(BaseStream<?, ?>[] streams) {
            this.streams = streams;
        }

        @Override
        public void run() {
            int i = 0;
            while (i < this.streams.length) {
                BaseStream<?, ?> stream = this.streams[i++];
                try {
                    stream.close();
                }
                catch (Throwable e1) {
                    while (i < this.streams.length) {
                        stream = this.streams[i++];
                        try {
                            stream.close();
                        }
                        catch (Throwable e2) {
                            e1.addSuppressed(e2);
                        }
                    }
                    throw e1;
                }
            }
        }
    }

    static abstract class ConcatSpliterator<T, T_SPLITR extends Spliterator<T>>
    implements Spliterator<T> {
        final T_SPLITR[] spliterators;
        int low;
        int cursor;
        final int high;

        ConcatSpliterator(T_SPLITR[] spliterators, int fromIndex, int toIndex) {
            this.spliterators = spliterators;
            this.low = this.cursor = fromIndex;
            this.high = toIndex;
        }

        abstract T_SPLITR invokeTrySplit(T_SPLITR var1);

        abstract T_SPLITR slice(int var1, int var2);

        @Override
        public int characteristics() {
            int i = this.low;
            if (i >= this.high) {
                return Spliterators.emptySpliterator().characteristics();
            }
            if (i == this.high - 1) {
                return this.spliterators[i].characteristics();
            }
            int characteristics = 21840;
            long size = 0L;
            do {
                T_SPLITR spliterator;
                if (((characteristics &= (spliterator = this.spliterators[i]).characteristics()) & 0x40) != 64 || (size += spliterator.estimateSize()) >= 0L) continue;
                characteristics &= 0xFFFFBFBF;
            } while (++i < this.high);
            return characteristics;
        }

        @Override
        public long estimateSize() {
            long size = 0L;
            for (int i = this.cursor; i < this.high; ++i) {
                if ((size += this.spliterators[i].estimateSize()) >= 0L) continue;
                return Long.MAX_VALUE;
            }
            return size;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            int i = this.cursor;
            if (i < this.high) {
                do {
                    this.spliterators[i].forEachRemaining(action);
                } while (++i < this.high);
                this.cursor = this.high;
            }
        }

        @Override
        public Comparator<? super T> getComparator() {
            int i = this.low;
            if (i == this.high - 1) {
                return this.spliterators[i].getComparator();
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            int i = this.cursor;
            if (i < this.high) {
                do {
                    if (!this.spliterators[i].tryAdvance(action)) continue;
                    this.cursor = i;
                    return true;
                } while (++i < this.high);
                this.cursor = this.high;
            }
            return false;
        }

        public T_SPLITR trySplit() {
            int mid;
            int i = this.cursor;
            if (i >= this.high) {
                return null;
            }
            if (i == this.high - 1) {
                return this.invokeTrySplit(this.spliterators[i]);
            }
            this.low = this.cursor = (mid = i + this.high >>> 1);
            if (mid == i + 1) {
                return this.spliterators[i];
            }
            return this.slice(i, mid);
        }

        static final class OfDouble
        extends OfPrimitive<Double, DoubleConsumer, Spliterator.OfDouble>
        implements Spliterator.OfDouble {
            OfDouble(Spliterator.OfDouble[] spliterators) {
                super((Spliterator.OfPrimitive[])spliterators, 0, spliterators.length);
            }

            OfDouble(Spliterator.OfDouble[] spliterators, int fromIndex, int toIndex) {
                super((Spliterator.OfPrimitive[])spliterators, fromIndex, toIndex);
            }

            @Override
            Spliterator.OfDouble invokeTrySplit(Spliterator.OfDouble spliterator) {
                return spliterator.trySplit();
            }

            @Override
            Spliterator.OfDouble slice(int fromIndex, int toIndex) {
                return new OfDouble((Spliterator.OfDouble[])this.spliterators, fromIndex, toIndex);
            }
        }

        static final class OfLong
        extends OfPrimitive<Long, LongConsumer, Spliterator.OfLong>
        implements Spliterator.OfLong {
            OfLong(Spliterator.OfLong[] spliterators) {
                super((Spliterator.OfPrimitive[])spliterators, 0, spliterators.length);
            }

            OfLong(Spliterator.OfLong[] spliterators, int fromIndex, int toIndex) {
                super((Spliterator.OfPrimitive[])spliterators, fromIndex, toIndex);
            }

            @Override
            Spliterator.OfLong invokeTrySplit(Spliterator.OfLong spliterator) {
                return spliterator.trySplit();
            }

            @Override
            Spliterator.OfLong slice(int fromIndex, int toIndex) {
                return new OfLong((Spliterator.OfLong[])this.spliterators, fromIndex, toIndex);
            }
        }

        static final class OfInt
        extends OfPrimitive<Integer, IntConsumer, Spliterator.OfInt>
        implements Spliterator.OfInt {
            OfInt(Spliterator.OfInt[] spliterators) {
                super((Spliterator.OfPrimitive[])spliterators, 0, spliterators.length);
            }

            OfInt(Spliterator.OfInt[] spliterators, int fromIndex, int toIndex) {
                super((Spliterator.OfPrimitive[])spliterators, fromIndex, toIndex);
            }

            @Override
            Spliterator.OfInt invokeTrySplit(Spliterator.OfInt spliterator) {
                return spliterator.trySplit();
            }

            @Override
            Spliterator.OfInt slice(int fromIndex, int toIndex) {
                return new OfInt((Spliterator.OfInt[])this.spliterators, fromIndex, toIndex);
            }
        }

        static abstract class OfPrimitive<T, T_CONS, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>>
        extends ConcatSpliterator<T, T_SPLITR>
        implements Spliterator.OfPrimitive<T, T_CONS, T_SPLITR> {
            OfPrimitive(T_SPLITR[] spliterators, int fromIndex, int toIndex) {
                super(spliterators, fromIndex, toIndex);
            }

            @Override
            public void forEachRemaining(T_CONS action) {
                Objects.requireNonNull(action);
                int i = this.cursor;
                if (i < this.high) {
                    do {
                        ((Spliterator.OfPrimitive[])this.spliterators)[i].forEachRemaining(action);
                    } while (++i < this.high);
                    this.cursor = this.high;
                }
            }

            @Override
            public boolean tryAdvance(T_CONS action) {
                Objects.requireNonNull(action);
                int i = this.cursor;
                if (i < this.high) {
                    do {
                        if (!((Spliterator.OfPrimitive[])this.spliterators)[i].tryAdvance(action)) continue;
                        this.cursor = i;
                        return true;
                    } while (++i < this.high);
                    this.cursor = this.high;
                }
                return false;
            }
        }

        static final class OfRef<T>
        extends ConcatSpliterator<T, Spliterator<T>> {
            OfRef(Spliterator<T>[] spliterators) {
                super((Spliterator[])spliterators, 0, spliterators.length);
            }

            OfRef(Spliterator<T>[] spliterators, int fromIndex, int toIndex) {
                super((Spliterator[])spliterators, fromIndex, toIndex);
            }

            @Override
            Spliterator<T> invokeTrySplit(Spliterator<T> spliterator) {
                return spliterator.trySplit();
            }

            @Override
            Spliterator<T> slice(int fromIndex, int toIndex) {
                return new OfRef<T>(this.spliterators, fromIndex, toIndex);
            }
        }
    }
}

