/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support.combinatorics;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.Nullable;

public class ConcatIterator<T>
implements Iterator<T> {
    private final List<? extends Iterator<? extends T>> iterators;
    private final AtomicInteger position;
    private @Nullable Iterator<? extends T> next;

    public ConcatIterator(List<? extends Iterator<? extends T>> iterators) {
        this.iterators = iterators;
        this.position = new AtomicInteger(0);
        if (!iterators.isEmpty()) {
            this.next = this.findNext();
        }
    }

    private @Nullable Iterator<? extends T> findNext() {
        while (!this.iterators.get(this.position.get()).hasNext()) {
            if (this.position.get() >= this.iterators.size() - 1) {
                return null;
            }
            this.position.getAndIncrement();
        }
        return this.iterators.get(this.position.get());
    }

    @Override
    public boolean hasNext() {
        return this.next != null && this.next.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T current = this.next.next();
        this.next = this.findNext();
        return current;
    }
}

