/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support.types;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Tuple;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.facades.RegisteredTypeUsageEnhancers;
import net.jqwik.engine.support.JqwikAnnotationSupport;
import net.jqwik.engine.support.JqwikExceptionSupport;
import net.jqwik.engine.support.JqwikReflectionSupport;
import net.jqwik.engine.support.JqwikStringSupport;
import net.jqwik.engine.support.MethodParameter;
import net.jqwik.engine.support.TypeResolution;
import net.jqwik.engine.support.types.TypeUsageToString;

public class TypeUsageImpl
implements TypeUsage,
Cloneable {
    private static final Map<TypeVariable<?>, TypeUsageImpl> resolvedTypeVariables = new ConcurrentHashMap();
    public static final String WILDCARD = "?";
    private final Class<?> rawType;
    private final Type type;
    private final AnnotatedType annotatedType;
    private final String typeVariable;
    private List<Annotation> annotations;
    private final List<TypeUsage> typeArguments = new ArrayList<TypeUsage>();
    private final List<TypeUsage> upperBounds = new ArrayList<TypeUsage>();
    private final List<TypeUsage> lowerBounds = new ArrayList<TypeUsage>();
    private HashMap<String, Object> metaInfo = new LinkedHashMap<String, Object>();
    private boolean isNullable = false;
    private volatile TypeUsage superclass = null;
    private volatile List<TypeUsage> interfaces = null;

    public static TypeUsage forParameterizedClass(Tuple.Tuple2<Class<?>, TypeUsage[]> parameterizedClass) {
        Class type = (Class)parameterizedClass.get1();
        TypeUsage[] typeParameters = (TypeUsage[])parameterizedClass.get2();
        if (typeParameters.length > 0 && typeParameters.length != type.getTypeParameters().length) {
            String typeArgumentsString = JqwikStringSupport.displayString(typeParameters);
            throw new JqwikException(String.format("Type [%s] cannot have type parameters [%s]", type, typeArgumentsString));
        }
        TypeUsageImpl typeUsage = new TypeUsageImpl(type, type, null, null, Collections.emptyList());
        typeUsage.addTypeArguments(Arrays.asList(typeParameters));
        return typeUsage;
    }

    public static TypeUsage wildcardOf(TypeUsage upperBound) {
        TypeUsageImpl typeUsage = new TypeUsageImpl(Object.class, (Type)((Object)Object.class), null, WILDCARD, Collections.emptyList());
        typeUsage.addUpperBounds(Arrays.asList(upperBound));
        return typeUsage;
    }

    public static TypeUsageImpl forType(Type type) {
        if (type instanceof WildcardType) {
            return TypeUsageImpl.wildcardOf((WildcardType)type);
        }
        return TypeUsageImpl.forNonWildcardType(type);
    }

    public static TypeUsage forResolution(TypeResolution typeResolution) {
        TypeUsageImpl typeUsage = new TypeUsageImpl(JqwikReflectionSupport.extractRawType(typeResolution.type()), typeResolution.type(), typeResolution.annotatedType(), TypeUsageImpl.extractTypeVariable(typeResolution.type()), TypeUsageImpl.extractAnnotations(typeResolution.annotatedType()));
        typeUsage.addTypeArguments(TypeUsageImpl.extractTypeArguments(typeResolution));
        typeUsage.addUpperBounds(TypeUsageImpl.extractUpperBounds(typeResolution.annotatedType()));
        typeUsage.addLowerBounds(TypeUsageImpl.extractLowerBounds(typeResolution.annotatedType()));
        return typeUsage;
    }

    public static TypeUsage forParameter(MethodParameter parameter) {
        return TypeUsageImpl.forParameter(parameter, RegisteredTypeUsageEnhancers.getEnhancers());
    }

    public static TypeUsage forParameter(MethodParameter parameter, List<TypeUsage.Enhancer> enhancerPipeline) {
        TypeUsageImpl typeUsage = new TypeUsageImpl(JqwikReflectionSupport.extractRawType(parameter.getType()), parameter.getType(), parameter.getAnnotatedType(), TypeUsageImpl.extractTypeVariable(parameter.getType()), parameter.findAllAnnotations());
        typeUsage.addTypeArguments(TypeUsageImpl.extractTypeArguments(parameter));
        typeUsage.addUpperBounds(TypeUsageImpl.extractUpperBounds(parameter));
        typeUsage.addLowerBounds(TypeUsageImpl.extractLowerBounds(parameter));
        return TypeUsageImpl.forParameterThroughEnhancerPipeline(parameter, enhancerPipeline, typeUsage);
    }

    private static TypeUsage forParameterThroughEnhancerPipeline(MethodParameter parameter, List<TypeUsage.Enhancer> enhancerPipeline, TypeUsageImpl typeUsage) {
        TypeUsageImpl enhanced = typeUsage;
        for (TypeUsage.Enhancer enhancer : enhancerPipeline) {
            enhanced = enhancer.forParameter((TypeUsage)enhanced, parameter.getRawParameter());
        }
        return enhanced;
    }

    public static TypeUsageImpl forNonWildcardType(Type type) {
        if (type.equals(Object.class)) {
            return (TypeUsageImpl)TypeUsage.OBJECT_TYPE;
        }
        return TypeUsageImpl.resolveVariableOrCreate(JqwikReflectionSupport.extractRawType(type), type, TypeUsageImpl.extractTypeVariable(type), Collections.emptyList(), typeUsage -> {
            typeUsage.addTypeArguments(TypeUsageImpl.extractPlainTypeArguments(type));
            typeUsage.addUpperBounds(TypeUsageImpl.extractUpperBounds(type));
            typeUsage.addLowerBounds(TypeUsageImpl.extractLowerBounds(type));
        });
    }

    public static TypeUsageImpl wildcardOf(WildcardType wildcardType) {
        return TypeUsageImpl.resolveVariableOrCreate(Object.class, wildcardType, WILDCARD, TypeUsageImpl.extractAnnotations(wildcardType), typeUsage -> {
            typeUsage.addUpperBounds(TypeUsageImpl.extractUpperBoundsForWildcard(wildcardType));
            typeUsage.addLowerBounds(TypeUsageImpl.extractLowerBoundsForWildcard(wildcardType));
        });
    }

    private static TypeUsageImpl forAnnotatedType(AnnotatedType annotatedType) {
        return TypeUsageImpl.resolveVariableOrCreate(JqwikReflectionSupport.extractRawType(annotatedType.getType()), annotatedType.getType(), annotatedType, TypeUsageImpl.extractTypeVariable(annotatedType.getType()), TypeUsageImpl.extractAnnotations(annotatedType), typeUsage -> {
            typeUsage.addTypeArguments(TypeUsageImpl.extractPlainTypeArguments(annotatedType));
            typeUsage.addUpperBounds(TypeUsageImpl.extractUpperBounds(annotatedType));
            typeUsage.addLowerBounds(TypeUsageImpl.extractLowerBounds(annotatedType));
        });
    }

    private static TypeUsageImpl resolveVariableOrCreate(Class<?> rawType, Type type, String typeVariable, List<Annotation> annotations, Consumer<TypeUsageImpl> processTypeUsage) {
        AnnotatedType annotatedType = type instanceof AnnotatedType ? (AnnotatedType)((Object)type) : null;
        return TypeUsageImpl.resolveVariableOrCreate(rawType, type, annotatedType, typeVariable, annotations, processTypeUsage);
    }

    private static TypeUsageImpl resolveVariableOrCreate(Class<?> rawType, Type type, AnnotatedType annotatedType, String typeVariable, List<Annotation> annotations, Consumer<TypeUsageImpl> processTypeUsage) {
        Optional<TypeUsageImpl> alreadyResolved;
        if (type instanceof TypeVariable && (alreadyResolved = TypeUsageImpl.alreadyResolvedIn((TypeVariable)type)).isPresent()) {
            return alreadyResolved.get();
        }
        TypeUsageImpl typeUsage = new TypeUsageImpl(rawType, type, annotatedType, typeVariable, annotations);
        if (type instanceof TypeVariable) {
            resolvedTypeVariables.put((TypeVariable)type, typeUsage);
        }
        processTypeUsage.accept(typeUsage);
        return typeUsage;
    }

    private static Optional<TypeUsageImpl> alreadyResolvedIn(TypeVariable<?> typeVariable) {
        return Optional.ofNullable(resolvedTypeVariables.get(typeVariable));
    }

    private static List<TypeUsage> extractTypeArguments(MethodParameter parameter) {
        if (parameter.getAnnotatedType() instanceof AnnotatedParameterizedType) {
            return TypeUsageImpl.extractAnnotatedTypeArguments((AnnotatedParameterizedType)parameter.getAnnotatedType());
        }
        return TypeUsageImpl.extractPlainTypeArguments(parameter.getType());
    }

    private static List<TypeUsage> extractTypeArguments(TypeResolution resolution) {
        if (resolution.annotatedType() instanceof AnnotatedParameterizedType) {
            return TypeUsageImpl.extractAnnotatedTypeArguments((AnnotatedParameterizedType)resolution.annotatedType());
        }
        return TypeUsageImpl.extractPlainTypeArguments(resolution.type());
    }

    private static List<TypeUsage> extractPlainTypeArguments(Object parameterizedType) {
        if (parameterizedType instanceof AnnotatedParameterizedType) {
            return TypeUsageImpl.extractAnnotatedTypeArguments((AnnotatedParameterizedType)parameterizedType);
        }
        if (parameterizedType instanceof ParameterizedType) {
            return TypeUsageImpl.toTypeUsages(((ParameterizedType)parameterizedType).getActualTypeArguments());
        }
        return Collections.emptyList();
    }

    private static List<TypeUsage> extractAnnotatedTypeArguments(AnnotatedParameterizedType annotatedType) {
        AnnotatedType[] annotatedActualTypeArguments = annotatedType.getAnnotatedActualTypeArguments();
        return TypeUsageImpl.toTypeUsages(annotatedActualTypeArguments);
    }

    private static List<TypeUsage> toTypeUsages(AnnotatedType[] annotatedActualTypeArguments) {
        return Arrays.stream(annotatedActualTypeArguments).filter(Objects::nonNull).map(TypeUsageImpl::forAnnotatedType).collect(Collectors.toList());
    }

    private static List<Annotation> extractAnnotations(Object parameterizedType) {
        if (parameterizedType instanceof AnnotatedElement) {
            return JqwikAnnotationSupport.findAllAnnotations((AnnotatedElement)parameterizedType);
        }
        return Collections.emptyList();
    }

    private static String extractTypeVariable(Type parameterizedType) {
        if (parameterizedType instanceof WildcardType) {
            return WILDCARD;
        }
        if (parameterizedType instanceof TypeVariable) {
            return ((TypeVariable)parameterizedType).getName();
        }
        return null;
    }

    private static List<TypeUsage> extractUpperBounds(AnnotatedType annotatedType) {
        AnnotatedType[] annotatedUpperBounds;
        List<Object> upperBounds = Collections.emptyList();
        if (annotatedType instanceof AnnotatedWildcardType) {
            annotatedUpperBounds = ((AnnotatedWildcardType)annotatedType).getAnnotatedUpperBounds();
            upperBounds = TypeUsageImpl.toTypeUsages(annotatedUpperBounds);
        }
        if (annotatedType instanceof AnnotatedTypeVariable) {
            annotatedUpperBounds = ((AnnotatedTypeVariable)annotatedType).getAnnotatedBounds();
            upperBounds = TypeUsageImpl.toTypeUsages(annotatedUpperBounds);
        }
        return upperBounds.isEmpty() ? Collections.singletonList(OBJECT_TYPE) : upperBounds;
    }

    private static List<TypeUsage> extractUpperBounds(MethodParameter parameter) {
        return TypeUsageImpl.extractUpperBounds(parameter.getAnnotatedType());
    }

    private static List<TypeUsage> extractUpperBounds(Type parameterizedType) {
        if (parameterizedType instanceof TypeVariable) {
            return TypeUsageImpl.extractUpperBoundsForTypeVariable((TypeVariable)parameterizedType);
        }
        if (parameterizedType instanceof WildcardType) {
            return TypeUsageImpl.extractUpperBoundsForWildcard((WildcardType)parameterizedType);
        }
        return Collections.emptyList();
    }

    private static List<TypeUsage> extractUpperBoundsForTypeVariable(TypeVariable<?> typeVariable) {
        Type[] upperBounds = typeVariable.getBounds();
        return TypeUsageImpl.toTypeUsages(upperBounds);
    }

    private static List<TypeUsage> extractUpperBoundsForWildcard(WildcardType wildcardType) {
        return TypeUsageImpl.toTypeUsages(wildcardType.getUpperBounds());
    }

    private static List<TypeUsage> toTypeUsages(Type[] upperBounds) {
        return Arrays.stream(upperBounds).filter(Objects::nonNull).map(TypeUsageImpl::forType).collect(Collectors.toList());
    }

    private static List<TypeUsage> extractLowerBounds(MethodParameter parameter) {
        return TypeUsageImpl.extractLowerBounds(parameter.getAnnotatedType());
    }

    private static List<TypeUsage> extractLowerBounds(AnnotatedType annotatedType) {
        if (annotatedType instanceof AnnotatedWildcardType) {
            AnnotatedType[] annotatedUpperBounds = ((AnnotatedWildcardType)annotatedType).getAnnotatedLowerBounds();
            return TypeUsageImpl.toTypeUsages(annotatedUpperBounds);
        }
        return Collections.emptyList();
    }

    private static List<TypeUsage> extractLowerBounds(Type parameterizedType) {
        if (parameterizedType instanceof WildcardType) {
            return TypeUsageImpl.extractLowerBoundsForWildcard((WildcardType)parameterizedType);
        }
        return Collections.emptyList();
    }

    private static List<TypeUsage> extractLowerBoundsForWildcard(WildcardType wildcardType) {
        return TypeUsageImpl.toTypeUsages(wildcardType.getLowerBounds());
    }

    public TypeUsageImpl(Class<?> rawType, Type type, AnnotatedType annotatedType, String typeVariable, List<Annotation> annotations) {
        if (rawType == null) {
            throw new IllegalArgumentException("rawType must never be null");
        }
        this.rawType = rawType;
        this.type = type;
        this.annotatedType = annotatedType;
        this.typeVariable = typeVariable;
        this.annotations = new ArrayList<Annotation>(annotations);
    }

    public void addTypeArguments(List<TypeUsage> typeArguments) {
        this.typeArguments.addAll(typeArguments);
    }

    public void addLowerBounds(List<TypeUsage> lowerBounds) {
        this.lowerBounds.addAll(lowerBounds);
    }

    public void addUpperBounds(List<TypeUsage> upperBounds) {
        this.upperBounds.addAll(upperBounds);
    }

    public List<TypeUsage> getUpperBounds() {
        return this.upperBounds;
    }

    public List<TypeUsage> getLowerBounds() {
        return this.lowerBounds;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    public boolean isWildcard() {
        return this.typeVariable != null && this.typeVariable.equals(WILDCARD);
    }

    public boolean isTypeVariable() {
        return this.typeVariable != null && !this.isWildcard();
    }

    public boolean isTypeVariableOrWildcard() {
        return this.isWildcard() || this.isTypeVariable();
    }

    public List<TypeUsage> getTypeArguments() {
        if (this.isSingleUpperBoundVariableType()) {
            return this.getUpperBounds().get(0).getTypeArguments();
        }
        return this.typeArguments;
    }

    private boolean isSingleUpperBoundVariableType() {
        return this.isTypeVariableOrWildcard() && this.getUpperBounds().size() == 1 && this.getLowerBounds().isEmpty();
    }

    public TypeUsage getTypeArgument(int position) {
        return this.getTypeArguments().size() <= position ? OBJECT_TYPE : this.getTypeArguments().get(position);
    }

    public boolean isOfType(Class<?> aRawType) {
        if (this.isTypeVariableOrWildcard()) {
            return false;
        }
        return this.rawType == aRawType;
    }

    public boolean canBeAssignedTo(TypeUsage targetType) {
        if (this.equals(targetType)) {
            return true;
        }
        if (targetType == OBJECT_TYPE) {
            return true;
        }
        if (targetType.isSuperWildcard() && this.isExtendsConstraint()) {
            return false;
        }
        if (targetType.isTypeVariableOrWildcard()) {
            return TypeUsageImpl.canBeAssignedToUpperBounds(this, targetType) && TypeUsageImpl.canBeAssignedToLowerBounds(this, targetType);
        }
        if (this.primitiveTypeToObject(this.getRawType(), targetType.getRawType())) {
            return true;
        }
        if (TypeUsageImpl.boxedTypeMatchesEitherWay(this, targetType)) {
            return true;
        }
        if (targetType.getRawType().isAssignableFrom(this.rawType)) {
            boolean isRecursive;
            if (this.isParameterizedRaw() || targetType.isParameterizedRaw()) {
                return true;
            }
            if (targetType.getTypeArgument(0).isExtendsConstraint() && (isRecursive = targetType.getTypeArgument(0).getUpperBounds().stream().anyMatch(upperBound -> upperBound.isOfType(targetType.getRawType())))) {
                return true;
            }
            if (this.allTypeArgumentsCanBeAssigned(this.getTypeArguments(), targetType.getTypeArguments())) {
                return true;
            }
            return this.anySupertypeCanBeAssignedTo(targetType);
        }
        return false;
    }

    private static boolean boxedTypeMatchesEitherWay(TypeUsage sourceType, TypeUsage targetType) {
        if (TypeUsageImpl.boxedTypeMatches(targetType.getRawType(), sourceType.getRawType())) {
            return true;
        }
        return TypeUsageImpl.boxedTypeMatches(sourceType.getRawType(), targetType.getRawType());
    }

    private boolean anySupertypeCanBeAssignedTo(TypeUsage targetType) {
        if (TypeUsageImpl.isInterface(this) && !TypeUsageImpl.isInterface(targetType) && !targetType.isOfType(Object.class)) {
            return false;
        }
        for (TypeUsage supertype : this.getSuperTypes()) {
            if (!supertype.canBeAssignedTo(targetType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInterface(TypeUsage targetType) {
        return targetType.getRawType().isInterface();
    }

    private boolean primitiveTypeToObject(Class<?> primitiveType, Class<?> objectType) {
        return primitiveType.isPrimitive() && objectType.equals(Object.class);
    }

    private static boolean canBeAssignedToUpperBounds(TypeUsage sourceType, TypeUsage targetType) {
        if (sourceType.isTypeVariableOrWildcard()) {
            return sourceType.getUpperBounds().stream().allMatch(upperBoundSource -> TypeUsageImpl.canBeAssignedToUpperBounds(upperBoundSource, targetType));
        }
        return targetType.getUpperBounds().stream().allMatch(upperBoundTarget -> sourceType.canBeAssignedTo(upperBoundTarget));
    }

    private static boolean canBeAssignedToLowerBounds(TypeUsage sourceType, TypeUsage targetType) {
        if (sourceType.isTypeVariableOrWildcard()) {
            return sourceType.getLowerBounds().stream().allMatch(lowerBoundSource -> TypeUsageImpl.canBeAssignedToLowerBounds(lowerBoundSource, targetType));
        }
        return targetType.getLowerBounds().stream().allMatch(lowerBoundTarget -> lowerBoundTarget.canBeAssignedTo(sourceType));
    }

    private boolean allTypeArgumentsCanBeAssigned(List<TypeUsage> providedTypeArguments, List<TypeUsage> targetTypeArguments) {
        if (targetTypeArguments.size() != providedTypeArguments.size()) {
            return false;
        }
        for (int i = 0; i < targetTypeArguments.size(); ++i) {
            TypeUsage targetTypeArgument;
            TypeUsage providedTypeArgument = providedTypeArguments.get(i);
            if (TypeUsageImpl.boxedTypeMatchesEitherWay(providedTypeArgument, targetTypeArgument = targetTypeArguments.get(i))) {
                return true;
            }
            boolean sameRawType = targetTypeArgument.getRawType().equals(providedTypeArgument.getRawType());
            if (!sameRawType && !targetTypeArgument.isTypeVariableOrWildcard()) {
                return false;
            }
            if (targetTypeArgument.isTypeVariable() && !providedTypeArgument.hasSameTypeAs(targetTypeArgument)) {
                return false;
            }
            if (providedTypeArgument.canBeAssignedTo(targetTypeArgument)) continue;
            return false;
        }
        return true;
    }

    public boolean isGeneric() {
        return this.typeArguments.size() > 0;
    }

    public boolean isEnum() {
        return this.getRawType().isEnum();
    }

    public boolean isArray() {
        return this.getRawType().isArray();
    }

    public List<Annotation> getAnnotations() {
        if (this.isSingleUpperBoundVariableType()) {
            return this.getAnnotationsStream().collect(Collectors.toList());
        }
        return Collections.unmodifiableList(this.annotations);
    }

    private Stream<Annotation> getAnnotationsStream() {
        if (this.isSingleUpperBoundVariableType()) {
            return Stream.concat(this.annotations.stream(), this.getUpperBounds().get(0).getAnnotations().stream());
        }
        return this.annotations.stream();
    }

    public <A extends Annotation> Optional<A> findAnnotation(Class<A> annotationType) {
        return this.getAnnotationsStream().filter(annotation -> annotation.annotationType().equals(annotationType)).map(annotationType::cast).findFirst();
    }

    public <A extends Annotation> boolean isAnnotated(Class<A> annotationType) {
        return this.findAnnotation(annotationType).isPresent();
    }

    public boolean isAssignableFrom(Class<?> providedClass) {
        return TypeUsage.of(providedClass, (TypeUsage[])new TypeUsage[0]).canBeAssignedTo((TypeUsage)this);
    }

    public Optional<TypeUsage> getComponentType() {
        if (!this.isArray()) {
            return Optional.empty();
        }
        return Optional.of(this.createComponentType());
    }

    private TypeUsage createComponentType() {
        if (this.type instanceof GenericArrayType) {
            return this.createGenericArrayComponentType((GenericArrayType)this.type);
        }
        return this.createSimpleArrayComponentType();
    }

    private TypeUsage createGenericArrayComponentType(GenericArrayType genericArrayType) {
        return TypeUsage.forType((Type)genericArrayType.getGenericComponentType());
    }

    private TypeUsageImpl createSimpleArrayComponentType() {
        Class<?> componentRawType = this.rawType.getComponentType();
        return (TypeUsageImpl)TypeUsage.of(componentRawType, (TypeUsage[])new TypeUsage[0]);
    }

    private static boolean boxedTypeMatches(Class<?> providedType, Class<?> targetType) {
        if (providedType.equals(Long.class) && targetType.equals(Long.TYPE)) {
            return true;
        }
        if (providedType.equals(Integer.class) && targetType.equals(Integer.TYPE)) {
            return true;
        }
        if (providedType.equals(Short.class) && targetType.equals(Short.TYPE)) {
            return true;
        }
        if (providedType.equals(Byte.class) && targetType.equals(Byte.TYPE)) {
            return true;
        }
        if (providedType.equals(Character.class) && targetType.equals(Character.TYPE)) {
            return true;
        }
        if (providedType.equals(Double.class) && targetType.equals(Double.TYPE)) {
            return true;
        }
        if (providedType.equals(Float.class) && targetType.equals(Float.TYPE)) {
            return true;
        }
        return providedType.equals(Boolean.class) && targetType.equals(Boolean.TYPE);
    }

    private TypeUsageImpl cloneWith(Consumer<TypeUsageImpl> updater) {
        try {
            TypeUsageImpl clone = (TypeUsageImpl)this.clone();
            updater.accept(clone);
            return clone;
        }
        catch (CloneNotSupportedException shouldNeverHappen) {
            return (TypeUsageImpl)JqwikExceptionSupport.throwAsUncheckedException(shouldNeverHappen);
        }
    }

    public boolean hasSameTypeAs(TypeUsage otherUsage) {
        if (this == otherUsage) {
            return true;
        }
        if (!(otherUsage instanceof TypeUsageImpl)) {
            return false;
        }
        TypeUsageImpl other = (TypeUsageImpl)otherUsage;
        if (!other.getRawType().equals(this.getRawType())) {
            return false;
        }
        if (!TypeUsageImpl.haveSameTypes(other.typeArguments, this.typeArguments)) {
            return false;
        }
        if (other.isWildcard() != this.isWildcard()) {
            return false;
        }
        if (other.isTypeVariable() != this.isTypeVariable()) {
            return false;
        }
        if (other.isWildcard() && this.isWildcard()) {
            if (!TypeUsageImpl.haveSameTypes(other.lowerBounds, this.lowerBounds)) {
                return false;
            }
            if (!TypeUsageImpl.haveSameTypes(other.upperBounds, this.upperBounds)) {
                return false;
            }
        }
        if (other.isTypeVariable() && this.isTypeVariable()) {
            return TypeUsageImpl.haveSameTypes(other.upperBounds, this.upperBounds);
        }
        return other.isNullable() == this.isNullable();
    }

    private static boolean haveSameTypes(List<TypeUsage> left, List<TypeUsage> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            if (left.get(i).hasSameTypeAs(right.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TypeUsageImpl other = (TypeUsageImpl)obj;
        if (!other.getRawType().equals(this.getRawType())) {
            return false;
        }
        if (!other.typeArguments.equals(this.typeArguments)) {
            return false;
        }
        if (!other.getAnnotations().equals(this.getAnnotations())) {
            return false;
        }
        if (other.isWildcard() != this.isWildcard()) {
            return false;
        }
        if (other.isTypeVariable() != this.isTypeVariable()) {
            return false;
        }
        if (other.isWildcard() && this.isWildcard()) {
            if (!other.lowerBounds.equals(this.lowerBounds)) {
                return false;
            }
            if (!other.upperBounds.equals(this.upperBounds)) {
                return false;
            }
        }
        if (other.isTypeVariable() && this.isTypeVariable()) {
            if (!other.typeVariable.equals(this.typeVariable)) {
                return false;
            }
            return other.upperBounds.equals(this.upperBounds);
        }
        return other.isNullable() == this.isNullable();
    }

    public boolean isVoid() {
        return this.rawType.equals(Void.class) || this.rawType.equals(Void.TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TypeUsage> getSuperclass() {
        if (this.rawType.getSuperclass() == null) {
            return Optional.empty();
        }
        if (this.superclass == null) {
            TypeUsageImpl typeUsageImpl = this;
            synchronized (typeUsageImpl) {
                if (this.superclass == null) {
                    this.superclass = this.createSuperclass();
                }
            }
        }
        return Optional.of(this.superclass);
    }

    private TypeUsageImpl createSuperclass() {
        return this.resolveSupertype(this.rawType.getGenericSuperclass());
    }

    private TypeUsageImpl resolveSupertype(Type supertype) {
        TypeUsageImpl resolvedSupertype = TypeUsageImpl.forType(supertype);
        return resolvedSupertype.replaceTypeVariablesFromSubtype(this);
    }

    private TypeUsageImpl replaceTypeVariablesFromSubtype(TypeUsageImpl subtype) {
        Map<String, TypeUsage> typeVariables = TypeUsageImpl.extractTypeVariables(subtype);
        TypeUsageImpl.replaceTypeVariablesIn(typeVariables, this);
        return this;
    }

    private static void replaceTypeVariablesIn(Map<String, TypeUsage> typeVariables, TypeUsageImpl replacementTarget) {
        for (int i = 0; i < replacementTarget.typeArguments.size(); ++i) {
            TypeUsage typeArgument = replacementTarget.typeArguments.get(i);
            if (typeArgument.isTypeVariable() && typeVariables.containsKey(typeArgument.getTypeVariable())) {
                replacementTarget.typeArguments.set(i, typeVariables.get(typeArgument.getTypeVariable()));
                continue;
            }
            TypeUsageImpl.replaceTypeVariablesIn(typeVariables, (TypeUsageImpl)typeArgument);
        }
    }

    private static Map<String, TypeUsage> extractTypeVariables(TypeUsage subtype) {
        List typeArgumentsFromSubtype = subtype.getTypeArguments();
        HashMap<String, TypeUsage> namedTypeArguments = new HashMap<String, TypeUsage>();
        for (int pos = 0; pos < typeArgumentsFromSubtype.size(); ++pos) {
            TypeVariable<Class<T>>[] rawTypeArguments;
            TypeUsage typeArgumentFromSubtype = (TypeUsage)typeArgumentsFromSubtype.get(pos);
            if (typeArgumentFromSubtype.isTypeVariable() || (rawTypeArguments = subtype.getRawType().getTypeParameters()).length < pos) continue;
            namedTypeArguments.put(rawTypeArguments[pos].getName(), typeArgumentFromSubtype);
        }
        return namedTypeArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TypeUsage> getInterfaces() {
        if (this.interfaces == null) {
            TypeUsageImpl typeUsageImpl = this;
            synchronized (typeUsageImpl) {
                if (this.interfaces == null) {
                    this.interfaces = this.createInterfaces();
                }
            }
        }
        return this.interfaces;
    }

    private List<TypeUsage> createInterfaces() {
        return Arrays.stream(this.getRawType().getGenericInterfaces()).filter(Objects::nonNull).map(type -> this.resolveSupertype((Type)type)).collect(Collectors.toList());
    }

    public List<TypeUsage> getSuperTypes() {
        ArrayList<TypeUsage> supertypes = new ArrayList<TypeUsage>();
        this.getSuperclass().ifPresent(e -> supertypes.add((TypeUsage)e));
        supertypes.addAll(this.getInterfaces());
        return supertypes;
    }

    public Type getType() {
        return this.type;
    }

    public AnnotatedType getAnnotatedType() {
        return this.annotatedType;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isParameterizedRaw() {
        return this.typeArguments.isEmpty() && this.getRawType().getTypeParameters().length > 0;
    }

    public boolean isSuperWildcard() {
        return this.isWildcard() && !this.lowerBounds.isEmpty();
    }

    public boolean isExtendsConstraint() {
        return this.isTypeVariableOrWildcard() && this.upperBounds.stream().anyMatch(b -> !b.getRawType().equals(Object.class));
    }

    public TypeUsage asNullable() {
        if (this.isNullable()) {
            return this;
        }
        return this.cloneWith(t -> {
            t.isNullable = true;
        });
    }

    public TypeUsage asNotNullable() {
        if (!this.isNullable()) {
            return this;
        }
        return this.cloneWith(t -> {
            t.isNullable = false;
        });
    }

    public String getTypeVariable() {
        return this.typeVariable;
    }

    public <A extends Annotation> TypeUsage withAnnotation(A annotation) {
        return this.cloneWith(t -> {
            t.annotations = new ArrayList<Annotation>(this.annotations);
            t.annotations.add(annotation);
            JqwikAnnotationSupport.allMetaAnnotations(annotation).stream().filter(candidate -> !t.annotations.contains(candidate)).forEach(metaAnnotation -> t.annotations.add((Annotation)metaAnnotation));
        });
    }

    public Optional<Object> getMetaInfo(String key) {
        return Optional.ofNullable(this.metaInfo.get(key));
    }

    public TypeUsage withMetaInfo(String key, Object value) {
        return this.cloneWith(t -> {
            t.metaInfo = new LinkedHashMap<String, Object>(this.metaInfo);
            t.metaInfo.put(key, value);
        });
    }

    public int hashCode() {
        return this.rawType.hashCode();
    }

    public String toString() {
        return TypeUsageToString.toString(this);
    }
}

