/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.combinations;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.engine.properties.arbitraries.combinations.CombineArbitrary;
import org.apiguardian.api.API;

public class DefaultListCombinator<T>
implements Combinators.ListCombinator<T> {
    protected final Arbitrary<T>[] arbitraries;

    public DefaultListCombinator(List<? extends Arbitrary<T>> listOfArbitraries) {
        this(listOfArbitraries.toArray(new Arbitrary[0]));
    }

    private DefaultListCombinator(Arbitrary<T>[] arbitraries) {
        this.arbitraries = arbitraries;
    }

    public <R> Arbitrary<R> as(Function<? super List<T>, ? extends R> combinator) {
        return new CombineArbitrary<R>(this.combineFunction(combinator), this.arbitraries);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.7.1")
    public Combinators.ListCombinator<T> filter(Predicate<? super List<? extends T>> filter) {
        return new Filtered(this.arbitraries, filter);
    }

    protected <R> Function<List<?>, R> combineFunction(Function<? super List<T>, ? extends R> combinator) {
        return params -> combinator.apply((Object)params);
    }

    private static class Filtered<T>
    extends DefaultListCombinator<T> {
        private final Predicate<? super List<? extends T>> filter;

        private Filtered(Arbitrary<T>[] arbitraries, Predicate<? super List<? extends T>> filter) {
            super(arbitraries);
            this.filter = filter;
        }

        @Override
        public <R> Arbitrary<R> as(Function<? super List<T>, ? extends R> combinator) {
            Predicate<List> filterPredicate = params -> this.filter.test((List<List>)params);
            return new CombineArbitrary(Function.identity(), this.arbitraries).filter(filterPredicate).map(this.combineFunction(combinator));
        }

        @Override
        public Combinators.ListCombinator<T> filter(Predicate<? super List<? extends T>> filter) {
            return super.filter(this.combineFilters(this.filter, filter));
        }

        private Predicate<? super List<? extends T>> combineFilters(Predicate<? super List<? extends T>> first, Predicate<? super List<? extends T>> second) {
            return it -> first.test((Object)it) && second.test((Object)it);
        }
    }
}

