/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.engine.support.Combinatorics;

public class FlatMappedExhaustiveGenerator<U, T>
implements ExhaustiveGenerator<U> {
    private final ExhaustiveGenerator<T> baseGenerator;
    private final long maxCount;
    private final Function<? super T, ? extends Arbitrary<U>> mapper;

    public static <T, U> Optional<Long> calculateMaxCounts(ExhaustiveGenerator<T> baseGenerator, Function<? super T, ? extends Arbitrary<U>> mapper, long maxNumberOfSamples) {
        long choices = 0L;
        for (Object baseValue : baseGenerator) {
            Optional exhaustive = mapper.apply(baseValue).exhaustive(maxNumberOfSamples);
            if (!exhaustive.isPresent()) {
                return Optional.empty();
            }
            if ((choices += ((ExhaustiveGenerator)exhaustive.get()).maxCount()) <= maxNumberOfSamples) continue;
            return Optional.empty();
        }
        return Optional.of(choices);
    }

    public FlatMappedExhaustiveGenerator(ExhaustiveGenerator<T> baseGenerator, long maxCount, Function<? super T, ? extends Arbitrary<U>> mapper) {
        this.baseGenerator = baseGenerator;
        this.maxCount = maxCount;
        this.mapper = mapper;
    }

    public long maxCount() {
        return this.maxCount;
    }

    public Iterator<U> iterator() {
        List iterators = StreamSupport.stream(this.baseGenerator.spliterator(), false).map(baseValue -> (Iterable)this.mapper.apply(baseValue).exhaustive().get()).collect(Collectors.toList());
        return Combinatorics.concat(iterators);
    }
}

