/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support.combinatorics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import net.jqwik.engine.support.combinatorics.CombinedIterator;

public class SetIterator<T>
implements Iterator<Set<T>> {
    private final Iterator<List<T>> combinedListIterator;
    private final Set<Set<T>> generatedSets = new LinkedHashSet<Set<T>>();
    private final int setSize;
    private Set<T> next;

    public SetIterator(Iterable<? extends T> elementIterable, int setSize) {
        this.setSize = setSize;
        ArrayList<Iterable<? extends T>> iterables = new ArrayList<Iterable<? extends T>>();
        for (int i = 0; i < setSize; ++i) {
            iterables.add(elementIterable);
        }
        this.combinedListIterator = new CombinedIterator(iterables);
        this.next = this.findNext();
    }

    private Set<T> findNext() {
        while (this.combinedListIterator.hasNext()) {
            LinkedHashSet candidate = new LinkedHashSet(this.combinedListIterator.next());
            if (candidate.size() != this.setSize || this.generatedSets.contains(candidate)) continue;
            this.generatedSets.add(candidate);
            return candidate;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Set<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Set<T> current = this.next;
        this.next = this.findNext();
        return current;
    }
}

