/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.configurators;

import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.FloatArbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.constraints.FloatRange;
import net.jqwik.api.providers.TypeUsage;

public class FloatRangeConfigurator
extends ArbitraryConfiguratorBase {
    protected boolean acceptTargetType(TypeUsage targetType) {
        return targetType.isAssignableFrom(Float.class);
    }

    public Arbitrary<Float> configure(Arbitrary<Float> arbitrary, FloatRange range) {
        if (arbitrary instanceof FloatArbitrary) {
            FloatArbitrary floatArbitrary = (FloatArbitrary)arbitrary;
            return floatArbitrary.between(range.min(), range.minIncluded(), range.max(), range.maxIncluded());
        }
        return arbitrary.filter(i -> i.floatValue() >= range.min() && i.floatValue() <= range.max());
    }
}

