/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.lifecycle;

import java.util.List;
import java.util.Optional;
import net.jqwik.api.EdgeCasesMode;
import net.jqwik.api.GenerationMode;
import net.jqwik.api.lifecycle.FalsifiedSample;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.ShrunkFalsifiedSample;
import net.jqwik.engine.execution.GenerationInfo;
import net.jqwik.engine.execution.lifecycle.ExtendedPropertyExecutionResult;
import org.jspecify.annotations.Nullable;

public class PlainExecutionResult
implements ExtendedPropertyExecutionResult {
    private final PropertyExecutionResult.Status status;
    private final GenerationInfo generationInfo;
    private final @Nullable Throwable throwable;

    public static ExtendedPropertyExecutionResult successful() {
        return new PlainExecutionResult(PropertyExecutionResult.Status.SUCCESSFUL, new GenerationInfo(null), null);
    }

    public static ExtendedPropertyExecutionResult failed(Throwable throwable, @Nullable String seed) {
        if (throwable == null) {
            throw new IllegalArgumentException("throwable must never be null for failed PropertyExecutionResult");
        }
        return new PlainExecutionResult(PropertyExecutionResult.Status.FAILED, new GenerationInfo(seed), throwable);
    }

    public static ExtendedPropertyExecutionResult aborted(Throwable throwable, String seed) {
        return PlainExecutionResult.aborted(throwable, new GenerationInfo(seed));
    }

    public static ExtendedPropertyExecutionResult aborted(Throwable throwable, GenerationInfo generationInfo) {
        if (throwable == null) {
            throw new IllegalArgumentException("throwable must never be null for aborted PropertyExecutionResult");
        }
        return new PlainExecutionResult(PropertyExecutionResult.Status.ABORTED, generationInfo, throwable);
    }

    private PlainExecutionResult(PropertyExecutionResult.Status status, GenerationInfo generationInfo, @Nullable Throwable throwable) {
        this.status = status;
        this.generationInfo = generationInfo;
        this.throwable = throwable;
    }

    public Optional<List<Object>> falsifiedParameters() {
        return Optional.empty();
    }

    public PropertyExecutionResult.Status status() {
        return this.status;
    }

    public Optional<Throwable> throwable() {
        return Optional.ofNullable(this.throwable);
    }

    public PropertyExecutionResult mapTo(PropertyExecutionResult.Status newStatus, @Nullable Throwable throwable) {
        return new PlainExecutionResult(newStatus, this.generationInfo, throwable);
    }

    @Override
    public boolean isExtended() {
        return false;
    }

    public int countChecks() {
        return 0;
    }

    public int countTries() {
        return 0;
    }

    public Optional<FalsifiedSample> originalSample() {
        return Optional.empty();
    }

    public Optional<ShrunkFalsifiedSample> shrunkSample() {
        return Optional.empty();
    }

    @Override
    public GenerationMode generation() {
        return GenerationMode.NOT_SET;
    }

    @Override
    public ExtendedPropertyExecutionResult.EdgeCasesExecutionResult edgeCases() {
        return new ExtendedPropertyExecutionResult.EdgeCasesExecutionResult(EdgeCasesMode.NOT_SET, 0, 0);
    }

    @Override
    public GenerationInfo generationInfo() {
        return this.generationInfo;
    }

    public String toString() {
        return String.format("PlainExecutionResult[%s]", this.status);
    }
}

