/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.facades;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.SampleReportingFormat;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.facades.TestingSupportFacade;
import net.jqwik.engine.execution.reporting.LineReporter;
import net.jqwik.engine.execution.reporting.SampleReportingFormats;
import net.jqwik.engine.execution.reporting.ValueReport;

public class TestingSupportFacadeImpl
extends TestingSupportFacade {
    public <T> Shrinkable<T> generateUntil(RandomGenerator<T> generator, Random random, Function<? super T, Boolean> condition) {
        long maxTries = 1000L;
        return generator.stream(random).limit(maxTries).filter(shrinkable -> (Boolean)condition.apply(shrinkable.value())).findFirst().orElseThrow(() -> new JqwikException("Failed to generate value that fits condition after " + maxTries + " tries."));
    }

    public String singleLineReport(Object any) {
        ValueReport report = ValueReport.of(any, this.getSampleReportingFormats());
        return report.singleLineReport();
    }

    public List<String> multiLineReport(Object any) {
        ValueReport report = ValueReport.of(any, this.getSampleReportingFormats());
        SimpleLineReporter lineReporter = new SimpleLineReporter();
        report.report(lineReporter, 0, "");
        return lineReporter.lines;
    }

    private Collection<SampleReportingFormat> getSampleReportingFormats() {
        return SampleReportingFormats.getReportingFormats();
    }

    private static class SimpleLineReporter
    implements LineReporter {
        final List<String> lines = new ArrayList<String>();

        private SimpleLineReporter() {
        }

        @Override
        public void addLine(int indentLevel, String line) {
            String indentation = LineReporter.multiply(' ', indentLevel * 2);
            this.lines.add(indentation + line.trim());
        }
    }
}

