/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.arbitraries.CharacterArbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.api.support.HashCodeSupport;
import net.jqwik.engine.properties.arbitraries.DefaultCharacterArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableString;

public class DefaultStringArbitrary
extends TypedCloneable
implements StringArbitrary {
    private CharacterArbitrary characterArbitrary = new DefaultCharacterArbitrary();
    private int minLength = 0;
    private Integer maxLength = null;
    private Set<Character> excludedChars = new LinkedHashSet<Character>();
    private RandomDistribution lengthDistribution = null;
    private double repeatChars = 0.0;
    private boolean uniqueChars = false;

    public RandomGenerator<String> generator(int genSize) {
        long maxUniqueChars = this.characterArbitrary.exhaustive((long)this.maxLength()).map(ExhaustiveGenerator::maxCount).orElse(Long.valueOf(this.maxLength()));
        return RandomGenerators.strings(this.randomCharacterGenerator(), this.minLength, this.maxLength(), maxUniqueChars, genSize, this.lengthDistribution, (Arbitrary<Character>)this.characterArbitrary, this.uniqueChars);
    }

    private int maxLength() {
        return RandomGenerators.collectionMaxSize(this.minLength, this.maxLength);
    }

    public Optional<ExhaustiveGenerator<String>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.strings(this.effectiveCharacterArbitrary(), this.minLength, this.maxLength(), maxNumberOfSamples, this.uniqueChars);
    }

    public EdgeCases<String> edgeCases(int maxEdgeCases) {
        if (maxEdgeCases <= 0) {
            return EdgeCases.none();
        }
        EdgeCases<String> emptyStringEdgeCases = this.hasEmptyStringEdgeCase() ? this.emptyStringEdgeCase() : EdgeCases.none();
        int effectiveMaxEdgeCases = maxEdgeCases - emptyStringEdgeCases.size();
        EdgeCases<String> singleCharEdgeCases = this.hasSingleCharEdgeCases() ? this.fixedSizedEdgeCases(1, effectiveMaxEdgeCases) : EdgeCases.none();
        EdgeCases<String> fixedSizeEdgeCases = this.hasMultiCharEdgeCases() ? this.fixedSizedEdgeCases(this.minLength, effectiveMaxEdgeCases -= singleCharEdgeCases.size()) : EdgeCases.none();
        return EdgeCasesSupport.concat(Arrays.asList(singleCharEdgeCases, emptyStringEdgeCases, fixedSizeEdgeCases), maxEdgeCases);
    }

    private boolean hasEmptyStringEdgeCase() {
        return this.minLength <= 0;
    }

    private boolean hasMultiCharEdgeCases() {
        return this.minLength <= this.maxLength() && this.minLength > 1 && !this.uniqueChars;
    }

    private boolean hasSingleCharEdgeCases() {
        return this.minLength <= 1 && this.maxLength() >= 1;
    }

    private EdgeCases<String> emptyStringEdgeCase() {
        return EdgeCases.fromSupplier(() -> new ShrinkableString(Collections.emptyList(), this.minLength, this.maxLength(), (Arbitrary<Character>)this.characterArbitrary, this.uniqueChars));
    }

    private EdgeCases<String> fixedSizedEdgeCases(int fixedSize, int maxEdgeCases) {
        return EdgeCasesSupport.mapShrinkable(this.effectiveCharacterArbitrary().edgeCases(maxEdgeCases), shrinkableChar -> {
            ArrayList<Shrinkable> shrinkableChars = new ArrayList<Shrinkable>(Collections.nCopies(fixedSize, shrinkableChar));
            return new ShrinkableString(shrinkableChars, this.minLength, this.maxLength(), (Arbitrary<Character>)this.characterArbitrary, this.uniqueChars);
        });
    }

    public StringArbitrary ofMinLength(int minLength) {
        if (minLength < 0) {
            String message = String.format("minLength (%s) must be between 0 and 2147483647", minLength);
            throw new IllegalArgumentException(message);
        }
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.minLength = minLength;
        return clone;
    }

    public StringArbitrary ofMaxLength(int maxLength) {
        if (maxLength < 0) {
            String message = String.format("maxLength (%s) must be between 0 and 2147483647", maxLength);
            throw new IllegalArgumentException(message);
        }
        if (maxLength < this.minLength) {
            String message = String.format("minLength (%s) must not be larger than maxLength (%s)", this.minLength, maxLength);
            throw new IllegalArgumentException(message);
        }
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.maxLength = maxLength;
        return clone;
    }

    public StringArbitrary withLengthDistribution(RandomDistribution distribution) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.lengthDistribution = distribution;
        return clone;
    }

    public StringArbitrary repeatChars(double repeatProbability) {
        if (repeatProbability < 0.0 || repeatProbability >= 1.0) {
            throw new IllegalArgumentException("repeatProbability must be between 0 (included) and 1 (excluded)");
        }
        if (Math.abs(repeatProbability) == 0.0) {
            return this.uniqueChars();
        }
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.repeatChars = repeatProbability;
        return clone;
    }

    public StringArbitrary uniqueChars() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.repeatChars = 0.0;
        clone.uniqueChars = true;
        return clone;
    }

    public StringArbitrary withChars(char ... chars) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.with(chars);
        return clone;
    }

    public StringArbitrary withChars(CharSequence chars) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.with(chars);
        return clone;
    }

    public StringArbitrary withCharRange(char from, char to) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.range(from, to);
        return clone;
    }

    public StringArbitrary ascii() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = this.characterArbitrary.ascii();
        return clone;
    }

    public StringArbitrary alpha() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.alpha();
        return clone;
    }

    public StringArbitrary numeric() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.numeric();
        return clone;
    }

    public StringArbitrary whitespace() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.whitespace();
        return clone;
    }

    public StringArbitrary all() {
        return this.withCharRange('\u0000', '\uffff');
    }

    public StringArbitrary excludeChars(char ... charsToExclude) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        LinkedHashSet<Character> excludedChars = new LinkedHashSet<Character>(this.excludedChars);
        for (char c : charsToExclude) {
            excludedChars.add(Character.valueOf(c));
        }
        clone.excludedChars = excludedChars;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultStringArbitrary that = (DefaultStringArbitrary)o;
        if (this.minLength != that.minLength) {
            return false;
        }
        if (!Objects.equals(this.maxLength, that.maxLength)) {
            return false;
        }
        if (Double.compare(that.repeatChars, this.repeatChars) != 0) {
            return false;
        }
        if (!this.characterArbitrary.equals((Object)that.characterArbitrary)) {
            return false;
        }
        if (!this.excludedChars.equals(that.excludedChars)) {
            return false;
        }
        return Objects.equals(this.lengthDistribution, that.lengthDistribution);
    }

    public int hashCode() {
        return HashCodeSupport.hash((Object)this.characterArbitrary, (Object)this.minLength, (Object)this.maxLength, (Object)this.repeatChars, this.excludedChars, (Object)this.lengthDistribution);
    }

    private RandomGenerator<Character> randomCharacterGenerator() {
        RandomGenerator characterGenerator = this.effectiveCharacterArbitrary().generator(1, false);
        if (this.repeatChars > 0.0) {
            return characterGenerator.injectDuplicates(this.repeatChars);
        }
        return characterGenerator;
    }

    private Arbitrary<Character> effectiveCharacterArbitrary() {
        CharacterArbitrary characterArbitrary = this.characterArbitrary;
        if (!this.excludedChars.isEmpty()) {
            characterArbitrary = characterArbitrary.filter(c -> !this.excludedChars.contains(c));
        }
        return characterArbitrary;
    }
}

