/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.spring;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.lifecycle.AroundTryHook;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.api.lifecycle.TryExecutor;
import net.jqwik.api.lifecycle.TryLifecycleContext;
import net.jqwik.spring.JqwikSpringExtension;
import org.springframework.test.context.TestContextManager;

class InsideLifecycleMethodsHook
implements AroundTryHook {
    InsideLifecycleMethodsHook() {
    }

    public boolean appliesTo(Optional<AnnotatedElement> optionalElement) {
        return optionalElement.map(element -> element instanceof Method).orElse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TryExecutionResult aroundTry(TryLifecycleContext context, TryExecutor aTry, List<Object> parameters) throws Exception {
        TryExecutionResult tryExecutionResult;
        Class containerClass = context.containerClass();
        TestContextManager testContextManager = JqwikSpringExtension.getTestContextManager(containerClass);
        Object testInstance = context.testInstance();
        Method testMethod = context.targetMethod();
        this.beforeExecution(testContextManager, testInstance, testMethod);
        Throwable testException = null;
        try {
            TryExecutionResult executionResult = aTry.execute(parameters);
            testException = executionResult.throwable().orElse(null);
            tryExecutionResult = executionResult;
        }
        catch (Throwable throwable) {
            this.afterExecution(testContextManager, testInstance, testMethod, testException);
            throw throwable;
        }
        this.afterExecution(testContextManager, testInstance, testMethod, testException);
        return tryExecutionResult;
    }

    public int aroundTryProximity() {
        return 100;
    }

    private void beforeExecution(TestContextManager testContextManager, Object testInstance, Method testMethod) throws Exception {
        testContextManager.beforeTestExecution(testInstance, testMethod);
    }

    public void afterExecution(TestContextManager testContextManager, Object testInstance, Method testMethod, Throwable testException) throws Exception {
        testContextManager.afterTestExecution(testInstance, testMethod, testException);
    }
}

