/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.spring;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.PropagationMode;
import net.jqwik.api.lifecycle.RegistrarHook;
import net.jqwik.api.lifecycle.Store;
import net.jqwik.spring.AroundSpringTestContainer;
import net.jqwik.spring.DisabledIfHook;
import net.jqwik.spring.EnabledIfHook;
import net.jqwik.spring.InsideLifecycleMethodsHook;
import net.jqwik.spring.OutsideLifecycleMethodsHook;
import net.jqwik.spring.ResolveSpringParametersHook;
import org.apiguardian.api.API;
import org.springframework.test.context.TestContextManager;

@API(status=API.Status.INTERNAL)
class JqwikSpringExtension
implements RegistrarHook {
    JqwikSpringExtension() {
    }

    public static TestContextManager getTestContextManager(Class<?> containerClass) {
        return (TestContextManager)JqwikSpringExtension.testContextManagerStore(containerClass).get();
    }

    private static Store<TestContextManager> testContextManagerStore(Class<?> containerClass) {
        return JqwikSpringExtension.getOrCreateTestContextManagerStore(containerClass);
    }

    public boolean appliesTo(Optional<AnnotatedElement> optionalElement) {
        return optionalElement.map(element -> element instanceof Class).orElse(false);
    }

    private static Store<TestContextManager> getOrCreateTestContextManagerStore(Class<?> containerClass) {
        return Store.getOrCreate(JqwikSpringExtension.storeIdentifier(containerClass), (Lifespan)Lifespan.RUN, () -> new TestContextManager(containerClass));
    }

    private static Tuple.Tuple2<?, ?> storeIdentifier(Class<?> containerClass) {
        return Tuple.of(JqwikSpringExtension.class, containerClass);
    }

    public void registerHooks(RegistrarHook.Registrar registrar) {
        registrar.register(AroundSpringTestContainer.class, PropagationMode.ALL_DESCENDANTS);
        registrar.register(OutsideLifecycleMethodsHook.class, PropagationMode.ALL_DESCENDANTS);
        registrar.register(InsideLifecycleMethodsHook.class, PropagationMode.ALL_DESCENDANTS);
        registrar.register(ResolveSpringParametersHook.class, PropagationMode.ALL_DESCENDANTS);
        registrar.register(EnabledIfHook.class, PropagationMode.ALL_DESCENDANTS);
        registrar.register(DisabledIfHook.class, PropagationMode.ALL_DESCENDANTS);
    }
}

