/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.api.arbitraries;

import java.time.DayOfWeek;
import java.time.Month;
import java.time.Year;
import java.util.Date;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.4.0")
public interface DateArbitrary
extends Arbitrary<Date> {
    default public DateArbitrary between(Date min, Date max) {
        if (min.after(max)) {
            return this.atTheEarliest(max).atTheLatest(min);
        }
        return this.atTheEarliest(min).atTheLatest(max);
    }

    public DateArbitrary atTheEarliest(Date var1);

    public DateArbitrary atTheLatest(Date var1);

    public DateArbitrary yearBetween(Year var1, Year var2);

    default public DateArbitrary yearBetween(int min, int max) {
        return this.yearBetween(Year.of(min), Year.of(max));
    }

    public DateArbitrary monthBetween(Month var1, Month var2);

    default public DateArbitrary monthBetween(int min, int max) {
        return this.monthBetween(Month.of(min), Month.of(max));
    }

    public DateArbitrary onlyMonths(Month ... var1);

    public DateArbitrary dayOfMonthBetween(int var1, int var2);

    public DateArbitrary onlyDaysOfWeek(DayOfWeek ... var1);

    public DateArbitrary leapYears(boolean var1);
}

