/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.util.Calendar;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.time.api.Dates;
import net.jqwik.time.api.arbitraries.CalendarArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultCalendarArbitrary
extends ArbitraryDecorator<Calendar>
implements CalendarArbitrary {
    private Calendar calendarMin = null;
    private Calendar calendarMax = null;
    private Year yearMin = null;
    private Year yearMax = null;
    private Month monthMin = null;
    private Month monthMax = null;
    private Month[] onlyMonths = null;
    private int dayOfMonthMin = -1;
    private int dayOfMonthMax = -1;
    private DayOfWeek[] onlyDayOfWeeks = null;
    private boolean withLeapYearsSet = false;
    private boolean withLeapYears = false;

    protected Arbitrary<Calendar> arbitrary() {
        LocalDateArbitrary dateArbitrary = Dates.dates();
        if (this.calendarMin != null) {
            dateArbitrary = dateArbitrary.atTheEarliest(this.calendarToLocalDate(this.calendarMin));
        }
        if (this.calendarMax != null) {
            dateArbitrary = dateArbitrary.atTheLatest(this.calendarToLocalDate(this.calendarMax));
        }
        if (this.yearMin != null && this.yearMax != null) {
            dateArbitrary = dateArbitrary.yearBetween(this.yearMin, this.yearMax);
        }
        if (this.monthMin != null && this.monthMax != null) {
            dateArbitrary = dateArbitrary.monthBetween(this.monthMin, this.monthMax);
        }
        if (this.onlyMonths != null) {
            dateArbitrary = dateArbitrary.onlyMonths(this.onlyMonths);
        }
        if (this.dayOfMonthMin != -1 && this.dayOfMonthMax != -1) {
            dateArbitrary = dateArbitrary.dayOfMonthBetween(this.dayOfMonthMin, this.dayOfMonthMax);
        }
        if (this.onlyDayOfWeeks != null) {
            dateArbitrary = dateArbitrary.onlyDaysOfWeek(this.onlyDayOfWeeks);
        }
        if (this.withLeapYearsSet) {
            dateArbitrary = dateArbitrary.leapYears(this.withLeapYears);
        }
        return dateArbitrary.map(DefaultCalendarArbitrary::localDateToCalendar);
    }

    @Override
    public CalendarArbitrary atTheEarliest(Calendar min) {
        if (min.get(0) != 1) {
            throw new IllegalArgumentException("Minimum year in a date must be > 0");
        }
        if (min.get(1) > 292278993) {
            throw new IllegalArgumentException("Minimum year in a calendar date must be <= 292278993");
        }
        if (this.calendarMax != null && min.after(this.calendarMax)) {
            throw new IllegalArgumentException("Minimum date must not be after maximum date");
        }
        DefaultCalendarArbitrary clone = (DefaultCalendarArbitrary)this.typedClone();
        clone.calendarMin = min;
        return clone;
    }

    @Override
    public CalendarArbitrary atTheLatest(Calendar max) {
        if (max.get(0) != 1) {
            throw new IllegalArgumentException("Maximum year in a date must be > 0");
        }
        if (max.get(1) > 292278993) {
            throw new IllegalArgumentException("Maximum year in a calendar date must be <= 292278993");
        }
        if (this.calendarMin != null && max.before(this.calendarMin)) {
            throw new IllegalArgumentException("Maximum date must not be before minimum date");
        }
        DefaultCalendarArbitrary clone = (DefaultCalendarArbitrary)this.typedClone();
        clone.calendarMax = max;
        return clone;
    }

    @Override
    public CalendarArbitrary yearBetween(Year min, Year max) {
        if (min.getValue() <= 0) {
            throw new IllegalArgumentException("Minimum year in a date must be > 0");
        }
        if (max.getValue() <= 0) {
            throw new IllegalArgumentException("Maximum year in a date must be > 0");
        }
        if (min.getValue() > 292278993) {
            throw new IllegalArgumentException("Minimum year in a calendar date must be <= 292278993");
        }
        if (max.getValue() > 292278993) {
            throw new IllegalArgumentException("Maximum year in a calendar date must be <= 292278993");
        }
        DefaultCalendarArbitrary clone = (DefaultCalendarArbitrary)this.typedClone();
        clone.yearMin = min;
        clone.yearMax = max;
        return clone;
    }

    @Override
    public CalendarArbitrary monthBetween(Month min, Month max) {
        if (min.compareTo(max) > 0) {
            throw new IllegalArgumentException("Minimum month cannot be after maximum month");
        }
        DefaultCalendarArbitrary clone = (DefaultCalendarArbitrary)this.typedClone();
        clone.monthMin = min;
        clone.monthMax = max;
        return clone;
    }

    @Override
    public CalendarArbitrary onlyMonths(Month ... months) {
        DefaultCalendarArbitrary clone = (DefaultCalendarArbitrary)this.typedClone();
        clone.onlyMonths = months;
        return clone;
    }

    @Override
    public CalendarArbitrary dayOfMonthBetween(int min, int max) {
        DefaultCalendarArbitrary clone = (DefaultCalendarArbitrary)this.typedClone();
        clone.dayOfMonthMin = min;
        clone.dayOfMonthMax = max;
        return clone;
    }

    @Override
    public CalendarArbitrary onlyDaysOfWeek(DayOfWeek ... daysOfWeek) {
        DefaultCalendarArbitrary clone = (DefaultCalendarArbitrary)this.typedClone();
        clone.onlyDayOfWeeks = daysOfWeek;
        return clone;
    }

    @Override
    public CalendarArbitrary leapYears(boolean withLeapYears) {
        DefaultCalendarArbitrary clone = (DefaultCalendarArbitrary)this.typedClone();
        clone.withLeapYearsSet = true;
        clone.withLeapYears = withLeapYears;
        return clone;
    }

    public static Calendar localDateToCalendar(LocalDate date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(date.getYear(), DefaultCalendarArbitrary.monthToCalendarMonth(date.getMonth()), date.getDayOfMonth(), 0, 0, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private LocalDate calendarToLocalDate(Calendar date) {
        return LocalDate.of(date.get(1), DefaultCalendarArbitrary.calendarMonthToMonth(date.get(2)), date.get(5));
    }

    public static int monthToCalendarMonth(Month month) {
        switch (month) {
            case JANUARY: {
                return 0;
            }
            case FEBRUARY: {
                return 1;
            }
            case MARCH: {
                return 2;
            }
            case APRIL: {
                return 3;
            }
            case MAY: {
                return 4;
            }
            case JUNE: {
                return 5;
            }
            case JULY: {
                return 6;
            }
            case AUGUST: {
                return 7;
            }
            case SEPTEMBER: {
                return 8;
            }
            case OCTOBER: {
                return 9;
            }
            case NOVEMBER: {
                return 10;
            }
        }
        return 11;
    }

    public static Month calendarMonthToMonth(Calendar calendar) {
        return DefaultCalendarArbitrary.calendarMonthToMonth(calendar.get(2));
    }

    public static Month calendarMonthToMonth(int month) {
        switch (month) {
            case 0: {
                return Month.JANUARY;
            }
            case 1: {
                return Month.FEBRUARY;
            }
            case 2: {
                return Month.MARCH;
            }
            case 3: {
                return Month.APRIL;
            }
            case 4: {
                return Month.MAY;
            }
            case 5: {
                return Month.JUNE;
            }
            case 6: {
                return Month.JULY;
            }
            case 7: {
                return Month.AUGUST;
            }
            case 8: {
                return Month.SEPTEMBER;
            }
            case 9: {
                return Month.OCTOBER;
            }
            case 10: {
                return Month.NOVEMBER;
            }
        }
        return Month.DECEMBER;
    }

    public static DayOfWeek calendarDayOfWeekToDayOfWeek(Calendar calendar) {
        return DefaultCalendarArbitrary.calendarDayOfWeekToDayOfWeek(calendar.get(7));
    }

    public static DayOfWeek calendarDayOfWeekToDayOfWeek(int dayOfWeek) {
        switch (dayOfWeek) {
            case 2: {
                return DayOfWeek.MONDAY;
            }
            case 3: {
                return DayOfWeek.TUESDAY;
            }
            case 4: {
                return DayOfWeek.WEDNESDAY;
            }
            case 5: {
                return DayOfWeek.THURSDAY;
            }
            case 6: {
                return DayOfWeek.FRIDAY;
            }
            case 7: {
                return DayOfWeek.SATURDAY;
            }
        }
        return DayOfWeek.SUNDAY;
    }
}

