/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.DayOfWeek;
import java.time.Month;
import java.time.Year;
import java.util.Calendar;
import java.util.Date;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.time.api.Dates;
import net.jqwik.time.api.arbitraries.CalendarArbitrary;
import net.jqwik.time.api.arbitraries.DateArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultDateArbitrary
extends ArbitraryDecorator<Date>
implements DateArbitrary {
    private Date dateMin = null;
    private Date dateMax = null;
    private Year yearMin = null;
    private Year yearMax = null;
    private Month monthMin = null;
    private Month monthMax = null;
    private Month[] onlyMonths = null;
    private int dayOfMonthMin = -1;
    private int dayOfMonthMax = -1;
    private DayOfWeek[] onlyDayOfWeeks = null;
    private boolean withLeapYearsSet = false;
    private boolean withLeapYears = false;

    protected Arbitrary<Date> arbitrary() {
        CalendarArbitrary calendarArbitrary = Dates.datesAsCalendar();
        if (this.dateMin != null) {
            calendarArbitrary = calendarArbitrary.atTheEarliest(this.dateToCalendar(this.dateMin));
        }
        if (this.dateMax != null) {
            calendarArbitrary = calendarArbitrary.atTheLatest(this.dateToCalendar(this.dateMax));
        }
        if (this.yearMin != null && this.yearMax != null) {
            calendarArbitrary = calendarArbitrary.yearBetween(this.yearMin, this.yearMax);
        }
        if (this.monthMin != null && this.monthMax != null) {
            calendarArbitrary = calendarArbitrary.monthBetween(this.monthMin, this.monthMax);
        }
        if (this.onlyMonths != null) {
            calendarArbitrary = calendarArbitrary.onlyMonths(this.onlyMonths);
        }
        if (this.dayOfMonthMin != -1 && this.dayOfMonthMax != -1) {
            calendarArbitrary = calendarArbitrary.dayOfMonthBetween(this.dayOfMonthMin, this.dayOfMonthMax);
        }
        if (this.onlyDayOfWeeks != null) {
            calendarArbitrary = calendarArbitrary.onlyDaysOfWeek(this.onlyDayOfWeeks);
        }
        if (this.withLeapYearsSet) {
            calendarArbitrary = calendarArbitrary.leapYears(this.withLeapYears);
        }
        return calendarArbitrary.map(Calendar::getTime);
    }

    @Override
    public DateArbitrary atTheEarliest(Date min) {
        Calendar calendar = this.dateToCalendar(min);
        if (calendar.get(0) != 1) {
            throw new IllegalArgumentException("Maximum year in a date must be > 0");
        }
        if (calendar.get(1) > 292278993) {
            throw new IllegalArgumentException("Minimum year in a calendar date must be <= 292278993");
        }
        if (this.dateMax != null && min.after(this.dateMax)) {
            throw new IllegalArgumentException("Minimum date must not be after maximum date");
        }
        DefaultDateArbitrary clone = (DefaultDateArbitrary)this.typedClone();
        clone.dateMin = min;
        return clone;
    }

    @Override
    public DateArbitrary atTheLatest(Date max) {
        Calendar calendar = this.dateToCalendar(max);
        if (calendar.get(0) != 1) {
            throw new IllegalArgumentException("Maximum year in a date must be > 0");
        }
        if (calendar.get(1) > 292278993) {
            throw new IllegalArgumentException("Maximum year in a calendar date must be <= 292278993");
        }
        if (this.dateMin != null && max.before(this.dateMin)) {
            throw new IllegalArgumentException("Maximum date must not be before minimum date");
        }
        DefaultDateArbitrary clone = (DefaultDateArbitrary)this.typedClone();
        clone.dateMax = max;
        return clone;
    }

    @Override
    public DateArbitrary yearBetween(Year min, Year max) {
        if (min.getValue() <= 0) {
            throw new IllegalArgumentException("Minimum year in a date must be > 0");
        }
        if (max.getValue() <= 0) {
            throw new IllegalArgumentException("Maximum year in a date must be > 0");
        }
        if (min.getValue() > 292278993) {
            throw new IllegalArgumentException("Minimum year in a calendar date must be <= 292278993");
        }
        if (max.getValue() > 292278993) {
            throw new IllegalArgumentException("Maximum year in a calendar date must be <= 292278993");
        }
        DefaultDateArbitrary clone = (DefaultDateArbitrary)this.typedClone();
        clone.yearMin = min;
        clone.yearMax = max;
        return clone;
    }

    @Override
    public DateArbitrary monthBetween(Month min, Month max) {
        if (min.compareTo(max) > 0) {
            throw new IllegalArgumentException("Minimum month cannot be after maximum month");
        }
        DefaultDateArbitrary clone = (DefaultDateArbitrary)this.typedClone();
        clone.monthMin = min;
        clone.monthMax = max;
        return clone;
    }

    @Override
    public DateArbitrary onlyMonths(Month ... months) {
        DefaultDateArbitrary clone = (DefaultDateArbitrary)this.typedClone();
        clone.onlyMonths = months;
        return clone;
    }

    @Override
    public DateArbitrary dayOfMonthBetween(int min, int max) {
        DefaultDateArbitrary clone = (DefaultDateArbitrary)this.typedClone();
        clone.dayOfMonthMin = min;
        clone.dayOfMonthMax = max;
        return clone;
    }

    @Override
    public DateArbitrary onlyDaysOfWeek(DayOfWeek ... daysOfWeek) {
        DefaultDateArbitrary clone = (DefaultDateArbitrary)this.typedClone();
        clone.onlyDayOfWeeks = daysOfWeek;
        return clone;
    }

    @Override
    public DateArbitrary leapYears(boolean withLeapYears) {
        DefaultDateArbitrary clone = (DefaultDateArbitrary)this.typedClone();
        clone.withLeapYearsSet = true;
        clone.withLeapYears = withLeapYears;
        return clone;
    }

    private Calendar dateToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }
}

