/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.math.BigInteger;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.api.arbitraries.BigIntegerArbitrary;
import net.jqwik.time.api.arbitraries.DurationArbitrary;
import net.jqwik.time.internal.properties.arbitraries.DefaultLocalTimeArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultDurationArbitrary
extends ArbitraryDecorator<Duration>
implements DurationArbitrary {
    public static final Duration DEFAULT_MIN = Duration.ofSeconds(Long.MIN_VALUE, 0L);
    public static final Duration DEFAULT_MAX = Duration.ofSeconds(Long.MAX_VALUE, 999999999L);
    private Duration min = DEFAULT_MIN;
    private Duration max = DEFAULT_MAX;
    private ChronoUnit ofPrecision = DefaultLocalTimeArbitrary.DEFAULT_PRECISION;
    private boolean ofPrecisionSet = false;

    protected Arbitrary<Duration> arbitrary() {
        Duration effectiveMax;
        Duration effectiveMin = DefaultDurationArbitrary.calculateEffectiveMin(this.min, this.ofPrecision);
        if (effectiveMin.compareTo(effectiveMax = DefaultDurationArbitrary.calculateEffectiveMax(this.max, this.ofPrecision)) > 0) {
            throw new IllegalArgumentException("The maximum duration is to soon after the minimum duration.");
        }
        BigInteger min = this.calculateValue(effectiveMin, this.ofPrecision);
        BigInteger max = this.calculateValue(effectiveMax, this.ofPrecision);
        Arbitrary bigIntegers = ((BigIntegerArbitrary)Arbitraries.bigIntegers().between(min, max).withDistribution(RandomDistribution.uniform())).edgeCases(edgeCases -> edgeCases.includeOnly((Object[])new BigInteger[]{min, BigInteger.ZERO, max}));
        return bigIntegers.map(big -> DefaultDurationArbitrary.calculateDuration(big, this.ofPrecision));
    }

    private static Duration calculateEffectiveMin(Duration min, ChronoUnit precision) {
        try {
            Duration effective = min;
            if (precision.compareTo(ChronoUnit.NANOS) >= 1) {
                if (effective.getNano() % 1000 != 0) {
                    effective = effective.plusNanos(1000 - effective.getNano() % 1000);
                }
                if (precision.compareTo(ChronoUnit.MICROS) >= 1) {
                    if (effective.getNano() % 1000000 != 0) {
                        effective = effective.plusNanos(1000000 - effective.getNano() % 1000000);
                    }
                    if (precision.compareTo(ChronoUnit.MILLIS) >= 1) {
                        if (effective.getNano() != 0) {
                            effective = effective.plusNanos(1000000000 - effective.getNano());
                        }
                        if (precision.compareTo(ChronoUnit.SECONDS) >= 1) {
                            int seconds = (int)(effective.getSeconds() % 60L);
                            if (seconds < 0) {
                                seconds += 60;
                            }
                            if (seconds != 0) {
                                effective = effective.plusSeconds(60 - seconds);
                            }
                            if (precision.compareTo(ChronoUnit.MINUTES) >= 1) {
                                int minutes = (int)(effective.getSeconds() % 3600L / 60L);
                                if (minutes < 0) {
                                    minutes += 60;
                                }
                                if (minutes != 0) {
                                    effective = effective.plusMinutes(60 - minutes);
                                }
                            }
                        }
                    }
                }
            }
            return effective;
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("Min value must be increased because of precision " + precision + " but results in a " + e.getMessage());
        }
    }

    private static Duration calculateEffectiveMax(Duration max, ChronoUnit precision) {
        try {
            Duration effective = max;
            if (precision.compareTo(ChronoUnit.NANOS) >= 1) {
                if (effective.getNano() % 1000 != 0) {
                    effective = effective.plusNanos(-(effective.getNano() % 1000));
                }
                if (precision.compareTo(ChronoUnit.MICROS) >= 1) {
                    if (effective.getNano() % 1000000 != 0) {
                        effective = effective.plusNanos(-(effective.getNano() % 1000000));
                    }
                    if (precision.compareTo(ChronoUnit.MILLIS) >= 1) {
                        if (effective.getNano() != 0) {
                            effective = effective.plusNanos(-effective.getNano());
                        }
                        if (precision.compareTo(ChronoUnit.SECONDS) >= 1) {
                            int seconds = (int)(effective.getSeconds() % 60L);
                            if (seconds < 0) {
                                seconds += 60;
                            }
                            if (seconds != 0) {
                                effective = effective.plusSeconds(-seconds);
                            }
                            if (precision.compareTo(ChronoUnit.MINUTES) >= 1) {
                                int minutes = (int)(effective.getSeconds() % 3600L / 60L);
                                if (minutes < 0) {
                                    minutes += 60;
                                }
                                if (minutes != 0) {
                                    effective = effective.plusMinutes(-minutes);
                                }
                            }
                        }
                    }
                }
            }
            return effective;
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("Max value must be decreased because of precision " + precision + " but results in a " + e.getMessage());
        }
    }

    private BigInteger calculateValue(Duration effective, ChronoUnit precision) {
        BigInteger helperMultiply = new BigInteger("1000000000");
        BigInteger helperDivide1000 = new BigInteger("1000");
        BigInteger helperDivide60 = new BigInteger("60");
        BigInteger bigInteger = new BigInteger(effective.getSeconds() + "");
        bigInteger = bigInteger.multiply(helperMultiply);
        bigInteger = bigInteger.add(new BigInteger(effective.getNano() + ""));
        if (precision.compareTo(ChronoUnit.NANOS) >= 1) {
            bigInteger = bigInteger.divide(helperDivide1000);
            if (precision.compareTo(ChronoUnit.MICROS) >= 1) {
                bigInteger = bigInteger.divide(helperDivide1000);
                if (precision.compareTo(ChronoUnit.MILLIS) >= 1) {
                    bigInteger = bigInteger.divide(helperDivide1000);
                    if (precision.compareTo(ChronoUnit.SECONDS) >= 1) {
                        bigInteger = bigInteger.divide(helperDivide60);
                        if (precision.compareTo(ChronoUnit.MINUTES) >= 1) {
                            bigInteger = bigInteger.divide(helperDivide60);
                        }
                    }
                }
            }
        }
        return bigInteger;
    }

    private static Duration calculateDuration(BigInteger bigInteger, ChronoUnit precision) {
        BigInteger helperDivide = new BigInteger("1000000000");
        BigInteger helperMultiply1000 = new BigInteger("1000");
        BigInteger helperMultiply60 = new BigInteger("60");
        switch (precision) {
            case HOURS: {
                bigInteger = bigInteger.multiply(helperMultiply60);
            }
            case MINUTES: {
                bigInteger = bigInteger.multiply(helperMultiply60);
            }
            case SECONDS: {
                bigInteger = bigInteger.multiply(helperMultiply1000);
            }
            case MILLIS: {
                bigInteger = bigInteger.multiply(helperMultiply1000);
            }
            case MICROS: {
                bigInteger = bigInteger.multiply(helperMultiply1000);
            }
        }
        BigInteger bigIntegerSeconds = bigInteger.divide(helperDivide);
        long seconds = bigIntegerSeconds.longValue();
        int nanos = bigInteger.subtract(bigIntegerSeconds.multiply(helperDivide)).intValue();
        return Duration.ofSeconds(seconds, nanos);
    }

    private void setOfPrecisionImplicitly(DefaultDurationArbitrary clone, Duration duration) {
        if (clone.ofPrecisionSet) {
            return;
        }
        ChronoUnit ofPrecision = DefaultLocalTimeArbitrary.calculateOfPrecisionFromNanos(duration.getNano());
        if (clone.ofPrecision.compareTo(ofPrecision) > 0) {
            clone.ofPrecision = ofPrecision;
        }
    }

    private void setOfPrecisionImplicitly(DefaultDurationArbitrary clone, Duration min, Duration max) {
        this.setOfPrecisionImplicitly(clone, min);
        this.setOfPrecisionImplicitly(clone, max);
    }

    @Override
    public DurationArbitrary between(Duration min, Duration max) {
        if (min.compareTo(max) > 0) {
            Duration remember = min;
            min = max;
            max = remember;
        }
        DefaultDurationArbitrary clone = (DefaultDurationArbitrary)this.typedClone();
        this.setOfPrecisionImplicitly(clone, min, max);
        clone.min = min;
        clone.max = max;
        return clone;
    }

    @Override
    public DurationArbitrary ofPrecision(ChronoUnit ofPrecision) {
        if (!DefaultLocalTimeArbitrary.ALLOWED_PRECISIONS.contains(ofPrecision)) {
            throw new IllegalArgumentException("Precision value must be one of these ChronoUnit values: HOURS, MINUTES, SECONDS, MILLIS, MICROS, NANOS");
        }
        DefaultDurationArbitrary clone = (DefaultDurationArbitrary)this.typedClone();
        clone.ofPrecisionSet = true;
        clone.ofPrecision = ofPrecision;
        return clone;
    }
}

