/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultLocalDateArbitrary
extends ArbitraryDecorator<LocalDate>
implements LocalDateArbitrary {
    public static final LocalDate DEFAULT_MIN_DATE = LocalDate.of(1900, 1, 1);
    public static final LocalDate DEFAULT_MAX_DATE = LocalDate.of(2500, 12, 31);
    private LocalDate dateMin = null;
    private LocalDate dateMax = null;
    private Set<Month> allowedMonths = new HashSet<Month>(Arrays.asList(Month.values()));
    private Set<DayOfWeek> allowedDayOfWeeks = new HashSet<DayOfWeek>(Arrays.asList(DayOfWeek.values()));
    private int dayOfMonthMin = 1;
    private int dayOfMonthMax = 31;
    private boolean withLeapYears = true;

    protected Arbitrary<LocalDate> arbitrary() {
        LocalDate effectiveMin = this.effectiveMinDate();
        LocalDate effectiveMax = this.effectiveMaxDate();
        long days = ChronoUnit.DAYS.between(effectiveMin, effectiveMax);
        Arbitrary day = ((LongArbitrary)Arbitraries.longs().between(0L, days).withDistribution(RandomDistribution.uniform())).edgeCases(edgeCases -> {
            edgeCases.includeOnly((Object[])new Long[]{0L, days});
            Optional<Long> optionalLeapDay = this.firstLeapDayAfter(effectiveMin, days);
            optionalLeapDay.ifPresent(xva$0 -> edgeCases.add((Object[])new Long[]{xva$0}));
        });
        Arbitrary localDates = day.map(effectiveMin::plusDays);
        if (this.allowedMonths.size() < 12) {
            localDates = localDates.filter(date -> this.allowedMonths.contains(date.getMonth()));
        }
        if (this.allowedDayOfWeeks.size() < 7) {
            localDates = localDates.filter(date -> this.allowedDayOfWeeks.contains(date.getDayOfWeek()));
        }
        if (this.dayOfMonthMax - this.dayOfMonthMin != 30) {
            localDates = localDates.filter(date -> date.getDayOfMonth() >= this.dayOfMonthMin && date.getDayOfMonth() <= this.dayOfMonthMax);
        }
        if (!this.withLeapYears) {
            localDates = localDates.filter(date -> !new GregorianCalendar().isLeapYear(date.getYear()));
        }
        return localDates;
    }

    private LocalDate effectiveMaxDate() {
        LocalDate effective = this.dateMax == null ? DEFAULT_MAX_DATE : this.dateMax;
        int latestMonth = this.latestAllowedMonth();
        if (latestMonth < effective.getMonth().getValue()) {
            return effective.withMonth(latestMonth);
        }
        if (this.dayOfMonthMax < effective.getDayOfMonth()) {
            return effective.withDayOfMonth(this.dayOfMonthMax);
        }
        return effective;
    }

    private int latestAllowedMonth() {
        return this.allowedMonths.stream().sorted((m1, m2) -> -Integer.compare(m1.getValue(), m2.getValue())).map(Month::getValue).findFirst().orElse(12);
    }

    private LocalDate effectiveMinDate() {
        LocalDate effective = this.dateMin == null ? DEFAULT_MIN_DATE : this.dateMin;
        int earliestMonth = this.earliestAllowedMonth();
        if (earliestMonth > effective.getMonth().getValue()) {
            return effective.withMonth(earliestMonth);
        }
        if (this.dayOfMonthMin > effective.getDayOfMonth()) {
            return effective.withDayOfMonth(this.dayOfMonthMin);
        }
        return effective;
    }

    private int earliestAllowedMonth() {
        return this.allowedMonths.stream().sorted(Comparator.comparing(Month::getValue)).map(Month::getValue).findFirst().orElse(1);
    }

    private Optional<Long> firstLeapDayAfter(LocalDate date, long maxOffset) {
        long offset = this.nextLeapDayOffset(date, 0L);
        if (offset > maxOffset) {
            return Optional.empty();
        }
        return Optional.of(offset);
    }

    private long nextLeapDayOffset(LocalDate date, long base) {
        if (date.isLeapYear() && date.getMonth().compareTo(Month.FEBRUARY) <= 0) {
            LocalDate leapDaySameYear = date.withMonth(2).withDayOfMonth(29);
            long offset = ChronoUnit.DAYS.between(date, leapDaySameYear);
            return base + offset;
        }
        int nextYear = date.getYear() + 1;
        if (nextYear > 999999999) {
            return Long.MAX_VALUE;
        }
        LocalDate nextJan1 = LocalDate.of(nextYear, 1, 1);
        return this.nextLeapDayOffset(nextJan1, base + ChronoUnit.DAYS.between(date, nextJan1));
    }

    @Override
    public LocalDateArbitrary atTheEarliest(LocalDate min) {
        if (min.getYear() <= 0) {
            throw new IllegalArgumentException("Minimum year in a date must be > 0");
        }
        if (this.dateMax != null && min.isAfter(this.dateMax)) {
            throw new IllegalArgumentException("Minimum date must not be after maximum date");
        }
        DefaultLocalDateArbitrary clone = (DefaultLocalDateArbitrary)this.typedClone();
        clone.dateMin = min;
        return clone;
    }

    @Override
    public LocalDateArbitrary atTheLatest(LocalDate max) {
        if (max.getYear() <= 0) {
            throw new IllegalArgumentException("Maximum year in a date must be > 0");
        }
        if (this.dateMin != null && max.isBefore(this.dateMin)) {
            throw new IllegalArgumentException("Maximum date must not be before minimum date");
        }
        DefaultLocalDateArbitrary clone = (DefaultLocalDateArbitrary)this.typedClone();
        clone.dateMax = max;
        return clone;
    }

    @Override
    public LocalDateArbitrary yearBetween(Year min, Year max) {
        if (!min.isBefore(max)) {
            Year remember = min;
            min = max;
            max = remember;
        }
        LocalDate minDate = LocalDate.of(min.getValue(), 1, 1);
        LocalDate maxDate = LocalDate.of(max.getValue(), 12, 31);
        return this.between(minDate, maxDate);
    }

    @Override
    public LocalDateArbitrary monthBetween(Month min, Month max) {
        if (min.compareTo(max) > 0) {
            throw new IllegalArgumentException("Minimum month cannot be after maximum month");
        }
        DefaultLocalDateArbitrary clone = (DefaultLocalDateArbitrary)this.typedClone();
        clone.allowedMonths = Arrays.stream(Month.values()).filter(m -> m.compareTo(min) >= 0 && m.compareTo(max) <= 0).collect(Collectors.toSet());
        return clone;
    }

    @Override
    public LocalDateArbitrary onlyMonths(Month ... months) {
        DefaultLocalDateArbitrary clone = (DefaultLocalDateArbitrary)this.typedClone();
        clone.allowedMonths = new HashSet<Month>(Arrays.asList(months));
        return clone;
    }

    @Override
    public LocalDateArbitrary dayOfMonthBetween(int min, int max) {
        if (min > max) {
            int remember = min;
            min = max;
            max = remember;
        }
        DefaultLocalDateArbitrary clone = (DefaultLocalDateArbitrary)this.typedClone();
        clone.dayOfMonthMin = Math.max(1, min);
        clone.dayOfMonthMax = Math.min(31, max);
        return clone;
    }

    @Override
    public LocalDateArbitrary onlyDaysOfWeek(DayOfWeek ... daysOfWeek) {
        DefaultLocalDateArbitrary clone = (DefaultLocalDateArbitrary)this.typedClone();
        clone.allowedDayOfWeeks = new HashSet<DayOfWeek>(Arrays.asList(daysOfWeek));
        return clone;
    }

    @Override
    public LocalDateArbitrary leapYears(boolean withLeapYears) {
        DefaultLocalDateArbitrary clone = (DefaultLocalDateArbitrary)this.typedClone();
        clone.withLeapYears = withLeapYears;
        return clone;
    }
}

