/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.time.api.Dates;
import net.jqwik.time.api.Times;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.LocalTimeArbitrary;
import net.jqwik.time.internal.properties.arbitraries.DefaultLocalDateArbitrary;
import net.jqwik.time.internal.properties.arbitraries.DefaultLocalTimeArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultLocalDateTimeArbitrary
extends ArbitraryDecorator<LocalDateTime>
implements LocalDateTimeArbitrary {
    private static final LocalDateTime DEFAULT_MIN = LocalDateTime.of(DefaultLocalDateArbitrary.DEFAULT_MIN_DATE, LocalTime.MIN);
    private static final LocalDateTime DEFAULT_MAX = LocalDateTime.of(DefaultLocalDateArbitrary.DEFAULT_MAX_DATE, LocalTime.MAX);
    private LocalDateTime min = null;
    private LocalDateTime max = null;
    private ChronoUnit ofPrecision = DefaultLocalTimeArbitrary.DEFAULT_PRECISION;
    private boolean ofPrecisionSet = false;

    protected Arbitrary<LocalDateTime> arbitrary() {
        LocalDateTime effectiveMin = this.calculateEffectiveMin();
        LocalDateTime effectiveMax = this.calculateEffectiveMax();
        if (effectiveMax.isBefore(effectiveMin)) {
            throw new IllegalArgumentException("The maximum date time is too soon after the minimum date time.");
        }
        LocalDateArbitrary dates = Dates.dates();
        TimeArbitraries times = this.generateTimeArbitraries(effectiveMin, effectiveMax, this.ofPrecision);
        dates = dates.atTheEarliest(effectiveMin.toLocalDate());
        dates = dates.atTheLatest(effectiveMax.toLocalDate());
        LocalDate effectiveMinDate = effectiveMin.toLocalDate();
        LocalDate effectiveMaxDate = effectiveMax.toLocalDate();
        return dates.flatMap(date -> this.timesByDate(times, (LocalDate)date, effectiveMinDate, effectiveMaxDate).map(time -> LocalDateTime.of(date, time)));
    }

    private LocalTimeArbitrary timesByDate(TimeArbitraries times, LocalDate date, LocalDate effectiveMin, LocalDate effectiveMax) {
        if (date.isEqual(effectiveMin)) {
            return times.firstDay;
        }
        if (date.isEqual(effectiveMax)) {
            return times.lastDay;
        }
        return times.daysBetween;
    }

    private LocalDateTime calculateEffectiveMin() {
        LocalDateTime effective = this.min != null ? this.min : DEFAULT_MIN;
        return this.calculateEffectiveMinWithPrecision(effective);
    }

    private LocalDateTime calculateEffectiveMinWithPrecision(LocalDateTime effective) {
        LocalDate date = effective.toLocalDate();
        LocalTime time = effective.toLocalTime();
        try {
            time = DefaultLocalTimeArbitrary.calculateEffectiveMinWithPrecision(time, this.ofPrecision);
        }
        catch (IllegalArgumentException e) {
            LocalDate effectiveDate;
            time = LocalTime.MIN;
            try {
                effectiveDate = date.plusDays(1L);
            }
            catch (DateTimeException dateTimeException) {
                throw e;
            }
            date = effectiveDate;
        }
        return LocalDateTime.of(date, time);
    }

    private LocalDateTime calculateEffectiveMax() {
        LocalDateTime effective = this.max != null ? this.max : DEFAULT_MAX;
        return this.calculateEffectiveMaxWithPrecision(effective);
    }

    private LocalDateTime calculateEffectiveMaxWithPrecision(LocalDateTime effective) {
        LocalDate date = effective.toLocalDate();
        LocalTime time = effective.toLocalTime();
        time = DefaultLocalTimeArbitrary.calculateEffectiveMaxWithPrecision(time, this.ofPrecision);
        return LocalDateTime.of(date, time);
    }

    private TimeArbitraries generateTimeArbitraries(LocalDateTime effectiveMin, LocalDateTime effectiveMax, ChronoUnit ofPrecision) {
        TimeArbitraries times = new TimeArbitraries();
        if (effectiveMin.toLocalDate().isEqual(effectiveMax.toLocalDate())) {
            times.firstDay = Times.times().between(effectiveMin.toLocalTime(), effectiveMax.toLocalTime()).ofPrecision(ofPrecision);
        } else {
            times.firstDay = Times.times().atTheEarliest(effectiveMin.toLocalTime()).ofPrecision(ofPrecision);
            times.daysBetween = Times.times().ofPrecision(ofPrecision);
            times.lastDay = Times.times().atTheLatest(effectiveMax.toLocalTime()).ofPrecision(ofPrecision);
        }
        return times;
    }

    private void setOfPrecisionImplicitly(DefaultLocalDateTimeArbitrary clone, LocalDateTime dateTime) {
        if (clone.ofPrecisionSet) {
            return;
        }
        ChronoUnit ofPrecision = DefaultLocalTimeArbitrary.calculateOfPrecisionFromTime(dateTime.toLocalTime());
        if (clone.ofPrecision.compareTo(ofPrecision) > 0) {
            clone.ofPrecision = ofPrecision;
        }
    }

    @Override
    public LocalDateTimeArbitrary atTheEarliest(LocalDateTime min) {
        if (min.getYear() <= 0) {
            throw new IllegalArgumentException("Minimum year in a date time must be > 0");
        }
        if (this.max != null && min.isAfter(this.max)) {
            throw new IllegalArgumentException("Minimum date time must not be after maximum date time");
        }
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        this.setOfPrecisionImplicitly(clone, min);
        clone.min = min;
        return clone;
    }

    @Override
    public LocalDateTimeArbitrary atTheLatest(LocalDateTime max) {
        if (max.getYear() <= 0) {
            throw new IllegalArgumentException("Minimum year in a date time must be > 0");
        }
        if (this.min != null && max.isBefore(this.min)) {
            throw new IllegalArgumentException("Maximum date time must not be before minimum date time");
        }
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        this.setOfPrecisionImplicitly(clone, max);
        clone.max = max;
        return clone;
    }

    @Override
    public LocalDateTimeArbitrary ofPrecision(ChronoUnit ofPrecision) {
        if (!DefaultLocalTimeArbitrary.ALLOWED_PRECISIONS.contains(ofPrecision)) {
            throw new IllegalArgumentException("Precision value must be one of these ChronoUnit values: HOURS, MINUTES, SECONDS, MILLIS, MICROS, NANOS");
        }
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        clone.ofPrecisionSet = true;
        clone.ofPrecision = ofPrecision;
        return clone;
    }

    private static class TimeArbitraries {
        private LocalTimeArbitrary firstDay;
        private LocalTimeArbitrary daysBetween;
        private LocalTimeArbitrary lastDay;

        private TimeArbitraries() {
        }
    }
}

