/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.time.api.arbitraries.LocalTimeArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultLocalTimeArbitrary
extends ArbitraryDecorator<LocalTime>
implements LocalTimeArbitrary {
    public static final ChronoUnit DEFAULT_PRECISION = ChronoUnit.SECONDS;
    public static final Set<ChronoUnit> ALLOWED_PRECISIONS = new HashSet<ChronoUnit>(Arrays.asList(ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS, ChronoUnit.MILLIS, ChronoUnit.MICROS, ChronoUnit.NANOS));
    private LocalTime timeMin = LocalTime.MIN;
    private LocalTime timeMax = LocalTime.MAX;
    private int hourMin = 0;
    private int hourMax = 23;
    private int minuteMin = 0;
    private int minuteMax = 59;
    private int secondMin = 0;
    private int secondMax = 59;
    private ChronoUnit ofPrecision = DEFAULT_PRECISION;
    private boolean ofPrecisionSet = false;

    protected Arbitrary<LocalTime> arbitrary() {
        LocalTime effectiveMin = this.calculateEffectiveMin();
        LocalTime effectiveMax = this.calculateEffectiveMax();
        if (effectiveMax.isBefore(effectiveMin)) {
            throw new IllegalArgumentException("The maximum time is too soon after the minimum time.");
        }
        long longEnd = this.calculateLongEnd(effectiveMin, effectiveMax);
        Arbitrary longs = ((LongArbitrary)Arbitraries.longs().withDistribution(RandomDistribution.uniform())).between(0L, longEnd).edgeCases(config -> config.includeOnly((Object[])new Long[]{0L, longEnd}));
        Arbitrary localTimes = longs.map(v -> DefaultLocalTimeArbitrary.calculateLocalTime(v, effectiveMin, this.ofPrecision));
        localTimes = localTimes.filter(v -> v.getMinute() >= this.minuteMin && v.getMinute() <= this.minuteMax && v.getSecond() >= this.secondMin && v.getSecond() <= this.secondMax);
        return localTimes;
    }

    private static LocalTime calculateLocalTime(long longAdd, LocalTime effectiveMin, ChronoUnit precision) {
        switch (precision) {
            case HOURS: {
                return effectiveMin.plusHours(longAdd);
            }
            case MINUTES: {
                return effectiveMin.plusMinutes(longAdd);
            }
            case SECONDS: {
                return effectiveMin.plusSeconds(longAdd);
            }
            case MILLIS: {
                longAdd *= 1000L;
            }
            case MICROS: {
                longAdd *= 1000L;
            }
        }
        return effectiveMin.plusNanos(longAdd);
    }

    private long calculateLongEnd(LocalTime effectiveMin, LocalTime effectiveMax) {
        switch (this.ofPrecision) {
            case HOURS: {
                return ChronoUnit.HOURS.between(effectiveMin, effectiveMax);
            }
            case MINUTES: {
                return ChronoUnit.MINUTES.between(effectiveMin, effectiveMax);
            }
            case SECONDS: {
                return ChronoUnit.SECONDS.between(effectiveMin, effectiveMax);
            }
            case MILLIS: {
                return ChronoUnit.MILLIS.between(effectiveMin, effectiveMax);
            }
            case MICROS: {
                return ChronoUnit.MICROS.between(effectiveMin, effectiveMax);
            }
        }
        return ChronoUnit.NANOS.between(effectiveMin, effectiveMax);
    }

    private LocalTime calculateEffectiveMin() {
        LocalTime effective = this.timeMin;
        if (this.hourMin > effective.getHour() && this.minuteMin > (effective = effective.withHour(this.hourMin)).getMinute() && this.secondMin > (effective = effective.withMinute(this.minuteMin)).getSecond()) {
            effective = effective.withSecond(this.secondMin);
            effective = effective.withNano(0);
        }
        effective = DefaultLocalTimeArbitrary.calculateEffectiveMinWithPrecision(effective, this.ofPrecision);
        return effective;
    }

    public static LocalTime calculateEffectiveMinWithPrecision(LocalTime effective, ChronoUnit precision) {
        LocalTime startEffective = effective;
        if (precision.compareTo(ChronoUnit.NANOS) >= 1) {
            if (effective.getNano() % 1000 != 0) {
                effective = effective.plusNanos(1000 - effective.getNano() % 1000);
            }
            if (precision.compareTo(ChronoUnit.MICROS) >= 1) {
                if (effective.getNano() % 1000000 != 0) {
                    effective = effective.plusNanos(1000000 - effective.getNano() % 1000000);
                }
                if (precision.compareTo(ChronoUnit.MILLIS) >= 1) {
                    if (effective.getNano() != 0) {
                        effective = effective.plusNanos(1000000000 - effective.getNano());
                    }
                    if (precision.compareTo(ChronoUnit.SECONDS) >= 1) {
                        if (effective.getSecond() != 0) {
                            effective = effective.plusSeconds(60 - effective.getSecond());
                        }
                        if (precision.compareTo(ChronoUnit.MINUTES) >= 1 && effective.getMinute() != 0) {
                            effective = effective.plusMinutes(60 - effective.getMinute());
                        }
                    }
                }
            }
        }
        if (startEffective.isAfter(effective)) {
            throw new IllegalArgumentException("Cannot use this min value with precision " + precision);
        }
        return effective;
    }

    private LocalTime calculateEffectiveMax() {
        LocalTime effective = this.timeMax;
        if (this.hourMax < effective.getHour() && this.minuteMax < (effective = effective.withHour(this.hourMax)).getMinute() && this.secondMax < (effective = effective.withMinute(this.minuteMax)).getSecond()) {
            effective = effective.withSecond(this.secondMax);
            effective = effective.withNano(999999999);
        }
        effective = DefaultLocalTimeArbitrary.calculateEffectiveMaxWithPrecision(effective, this.ofPrecision);
        return effective;
    }

    public static LocalTime calculateEffectiveMaxWithPrecision(LocalTime effective, ChronoUnit ofPrecision) {
        switch (ofPrecision) {
            case HOURS: {
                effective = effective.withMinute(0);
            }
            case MINUTES: {
                effective = effective.withSecond(0);
            }
            case SECONDS: {
                effective = effective.withNano(effective.getNano() % 1000000);
            }
            case MILLIS: {
                effective = effective.withNano(effective.getNano() / 1000000 * 1000000 + effective.getNano() % 1000);
            }
            case MICROS: {
                effective = effective.withNano(effective.getNano() - effective.getNano() % 1000);
            }
        }
        return effective;
    }

    public static ChronoUnit calculateOfPrecisionFromNanos(int nanos) {
        ChronoUnit ofPrecision = DEFAULT_PRECISION;
        if (nanos % 1000 != 0) {
            ofPrecision = ChronoUnit.NANOS;
        } else if (nanos / 1000 % 1000 != 0) {
            ofPrecision = ChronoUnit.MICROS;
        } else if (nanos / 1000000 != 0) {
            ofPrecision = ChronoUnit.MILLIS;
        }
        return ofPrecision;
    }

    public static ChronoUnit calculateOfPrecisionFromTime(LocalTime time) {
        int nanos = time.getNano();
        return DefaultLocalTimeArbitrary.calculateOfPrecisionFromNanos(nanos);
    }

    private void setOfPrecisionImplicitly(DefaultLocalTimeArbitrary clone, LocalTime time) {
        if (clone.ofPrecisionSet) {
            return;
        }
        ChronoUnit ofPrecision = DefaultLocalTimeArbitrary.calculateOfPrecisionFromTime(time);
        if (clone.ofPrecision.compareTo(ofPrecision) > 0) {
            clone.ofPrecision = ofPrecision;
        }
    }

    @Override
    public LocalTimeArbitrary atTheEarliest(LocalTime min) {
        if (this.timeMax != null && min.isAfter(this.timeMax)) {
            throw new IllegalArgumentException("Minimum time must not be after maximum time");
        }
        DefaultLocalTimeArbitrary clone = (DefaultLocalTimeArbitrary)this.typedClone();
        this.setOfPrecisionImplicitly(clone, min);
        clone.timeMin = min;
        return clone;
    }

    @Override
    public LocalTimeArbitrary atTheLatest(LocalTime max) {
        if (this.timeMin != null && max.isBefore(this.timeMin)) {
            throw new IllegalArgumentException("Maximum time must not be before minimum time");
        }
        DefaultLocalTimeArbitrary clone = (DefaultLocalTimeArbitrary)this.typedClone();
        this.setOfPrecisionImplicitly(clone, max);
        clone.timeMax = max;
        return clone;
    }

    @Override
    public LocalTimeArbitrary hourBetween(int min, int max) {
        if (min > max) {
            int remember = min;
            min = max;
            max = remember;
        }
        if (min < 0 || max > 23) {
            throw new IllegalArgumentException("Hour value must be between 0 and 23.");
        }
        DefaultLocalTimeArbitrary clone = (DefaultLocalTimeArbitrary)this.typedClone();
        clone.hourMin = min;
        clone.hourMax = max;
        return clone;
    }

    @Override
    public LocalTimeArbitrary minuteBetween(int min, int max) {
        if (min > max) {
            int remember = min;
            min = max;
            max = remember;
        }
        if (min < 0 || max > 59) {
            throw new IllegalArgumentException("Minute value must be between 0 and 59.");
        }
        DefaultLocalTimeArbitrary clone = (DefaultLocalTimeArbitrary)this.typedClone();
        clone.minuteMin = min;
        clone.minuteMax = max;
        return clone;
    }

    @Override
    public LocalTimeArbitrary secondBetween(int min, int max) {
        if (min > max) {
            int remember = min;
            min = max;
            max = remember;
        }
        if (min < 0 || max > 59) {
            throw new IllegalArgumentException("Second value must be between 0 and 59.");
        }
        DefaultLocalTimeArbitrary clone = (DefaultLocalTimeArbitrary)this.typedClone();
        clone.secondMin = min;
        clone.secondMax = max;
        return clone;
    }

    @Override
    public LocalTimeArbitrary ofPrecision(ChronoUnit ofPrecision) {
        if (!ALLOWED_PRECISIONS.contains(ofPrecision)) {
            throw new IllegalArgumentException("Precision value must be one of these ChronoUnit values: HOURS, MINUTES, SECONDS, MILLIS, MICROS, NANOS");
        }
        DefaultLocalTimeArbitrary clone = (DefaultLocalTimeArbitrary)this.typedClone();
        clone.ofPrecisionSet = true;
        clone.ofPrecision = ofPrecision;
        return clone;
    }
}

