/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.Period;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.time.api.arbitraries.PeriodArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultPeriodArbitrary
extends ArbitraryDecorator<Period>
implements PeriodArbitrary {
    private static final long DAYS_PER_MONTH = 31L;
    private static final long DAYS_PER_YEAR = 372L;
    private Period min = Period.ofYears(-1000);
    private Period max = Period.ofYears(1000);

    protected Arbitrary<Period> arbitrary() {
        long minInDays = DefaultPeriodArbitrary.inDays(this.min);
        long maxInDays = DefaultPeriodArbitrary.inDays(this.max);
        Arbitrary days = Arbitraries.longs().between(minInDays, maxInDays).edgeCases(edgeCases -> edgeCases.includeOnly((Object[])new Long[]{minInDays, 0L, maxInDays}));
        return days.map(DefaultPeriodArbitrary::calculatePeriod);
    }

    private static Period calculatePeriod(long periodInDays) {
        int years = Math.toIntExact(periodInDays / 372L);
        int months = Math.toIntExact((periodInDays %= 372L) / 31L);
        int days = Math.toIntExact(periodInDays % 31L);
        return Period.of(years, months, days);
    }

    private static long inDays(Period period) {
        return (long)period.getYears() * 372L + (long)period.getMonths() * 31L + (long)period.getDays();
    }

    @Override
    public PeriodArbitrary between(Period min, Period max) {
        if (DefaultPeriodArbitrary.inDays(min) > DefaultPeriodArbitrary.inDays(max)) {
            Period remember = min;
            min = max;
            max = remember;
        }
        DefaultPeriodArbitrary clone = (DefaultPeriodArbitrary)this.typedClone();
        clone.min = min;
        clone.max = max;
        return clone;
    }
}

