/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.Year;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.time.api.arbitraries.YearArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultYearArbitrary
extends ArbitraryDecorator<Year>
implements YearArbitrary {
    private Year min = Year.of(1900);
    private Year max = Year.of(2500);

    protected Arbitrary<Year> arbitrary() {
        Arbitrary years = Arbitraries.integers().between(this.min.getValue(), this.max.getValue()).filter(v -> v != 0);
        return years.map(Year::of);
    }

    @Override
    public YearArbitrary between(Year min, Year max) {
        DefaultYearArbitrary clone = (DefaultYearArbitrary)this.typedClone();
        min = Year.of(Math.max(min.getValue(), -999999999));
        max = Year.of(Math.min(max.getValue(), 999999999));
        clone.min = min;
        clone.max = max;
        return clone;
    }
}

