/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.time.api.arbitraries.YearMonthArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultYearMonthArbitrary
extends ArbitraryDecorator<YearMonth>
implements YearMonthArbitrary {
    private static final YearMonth DEFAULT_MIN = YearMonth.of(1900, 1);
    private static final YearMonth DEFAULT_MAX = YearMonth.of(2500, 12);
    private YearMonth yearMonthMin = null;
    private YearMonth yearMonthMax = null;
    private Set<Month> allowedMonths = new HashSet<Month>(Arrays.asList(Month.values()));
    private boolean withLeapYears = true;

    protected Arbitrary<YearMonth> arbitrary() {
        YearMonth effectiveMin = this.yearMonthMin == null ? DEFAULT_MIN : this.yearMonthMin;
        YearMonth effectiveMax = this.yearMonthMax == null ? DEFAULT_MAX : this.yearMonthMax;
        long months = ChronoUnit.MONTHS.between(effectiveMin, effectiveMax);
        Arbitrary month = ((LongArbitrary)Arbitraries.longs().between(0L, months).withDistribution(RandomDistribution.uniform())).edgeCases(edgeCases -> edgeCases.includeOnly((Object[])new Long[]{0L, months}));
        Arbitrary yearMonths = month.map(effectiveMin::plusMonths);
        if (this.allowedMonths.size() < 12) {
            yearMonths = yearMonths.filter(yearMonth -> this.allowedMonths.contains(yearMonth.getMonth()));
        }
        if (!this.withLeapYears) {
            yearMonths = yearMonths.filter(date -> !new GregorianCalendar().isLeapYear(date.getYear()));
        }
        return yearMonths;
    }

    @Override
    public YearMonthArbitrary atTheEarliest(YearMonth min) {
        if (min.getYear() <= 0) {
            throw new IllegalArgumentException("Minimum year in a year-month must be > 0");
        }
        if (this.yearMonthMax != null && min.isAfter(this.yearMonthMax)) {
            throw new IllegalArgumentException("Minimum year-month must not be after maximum year-month");
        }
        DefaultYearMonthArbitrary clone = (DefaultYearMonthArbitrary)this.typedClone();
        clone.yearMonthMin = min;
        return clone;
    }

    @Override
    public YearMonthArbitrary atTheLatest(YearMonth max) {
        if (max.getYear() <= 0) {
            throw new IllegalArgumentException("Maximum year in a date year-month be > 0");
        }
        if (this.yearMonthMin != null && max.isBefore(this.yearMonthMin)) {
            throw new IllegalArgumentException("Maximum year-month must not be before minimum year-month");
        }
        DefaultYearMonthArbitrary clone = (DefaultYearMonthArbitrary)this.typedClone();
        clone.yearMonthMax = max;
        return clone;
    }

    @Override
    public YearMonthArbitrary yearBetween(Year min, Year max) {
        if (!min.isBefore(max)) {
            Year remember = min;
            min = max;
            max = remember;
        }
        YearMonth minDate = YearMonth.of(min.getValue(), 1);
        YearMonth maxDate = YearMonth.of(max.getValue(), 12);
        return this.between(minDate, maxDate);
    }

    @Override
    public YearMonthArbitrary monthBetween(Month min, Month max) {
        if (min.compareTo(max) > 0) {
            throw new IllegalArgumentException("Minimum month cannot be after maximum month");
        }
        DefaultYearMonthArbitrary clone = (DefaultYearMonthArbitrary)this.typedClone();
        clone.allowedMonths = Arrays.stream(Month.values()).filter(m -> m.compareTo(min) >= 0 && m.compareTo(max) <= 0).collect(Collectors.toSet());
        return clone;
    }

    @Override
    public YearMonthArbitrary onlyMonths(Month ... months) {
        DefaultYearMonthArbitrary clone = (DefaultYearMonthArbitrary)this.typedClone();
        clone.allowedMonths = new HashSet<Month>(Arrays.asList(months));
        return clone;
    }

    @Override
    public YearMonthArbitrary leapYears(boolean withLeapYears) {
        DefaultYearMonthArbitrary clone = (DefaultYearMonthArbitrary)this.typedClone();
        clone.withLeapYears = withLeapYears;
        return clone;
    }
}

