/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.ZoneOffset;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.time.api.arbitraries.ZoneOffsetArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultZoneOffsetArbitrary
extends ArbitraryDecorator<ZoneOffset>
implements ZoneOffsetArbitrary {
    public static final ZoneOffset DEFAULT_MIN = ZoneOffset.ofHoursMinutesSeconds(-12, 0, 0);
    public static final ZoneOffset DEFAULT_MAX = ZoneOffset.ofHoursMinutesSeconds(14, 0, 0);
    private ZoneOffset offsetMin = DEFAULT_MIN;
    private ZoneOffset offsetMax = DEFAULT_MAX;

    protected Arbitrary<ZoneOffset> arbitrary() {
        ZoneOffset effectiveMin = this.calculateEffectiveMin();
        ZoneOffset effectiveMax = this.calculateEffectiveMax();
        if (effectiveMin.getTotalSeconds() > effectiveMax.getTotalSeconds()) {
            throw new IllegalArgumentException("With this configuration is no value possible.");
        }
        int min = this.calculateIndex(effectiveMin);
        int max = this.calculateIndex(effectiveMax);
        Arbitrary indexes = ((IntegerArbitrary)Arbitraries.integers().withDistribution(RandomDistribution.uniform())).between(min, max).edgeCases(edgeCases -> edgeCases.includeOnly((Object[])new Integer[]{min, 0, max}));
        return indexes.map(DefaultZoneOffsetArbitrary::calculateOffset);
    }

    private ZoneOffset calculateEffectiveMin() {
        boolean isNegative = this.offsetMin.getTotalSeconds() < 0;
        int hour = this.calculateHourValue(this.offsetMin);
        int minute = this.calculateMinuteValue(this.offsetMin);
        int second = this.calculateSecondValue(this.offsetMin);
        if (second != 0 && !isNegative && ++minute > 59) {
            minute -= 60;
            ++hour;
        }
        while (minute % 15 != 0) {
            if (isNegative || (minute += isNegative ? -1 : 1) != 60) continue;
            minute = 0;
            ++hour;
        }
        if (isNegative) {
            minute = -minute;
        }
        return ZoneOffset.ofHoursMinutes(hour, minute);
    }

    private ZoneOffset calculateEffectiveMax() {
        boolean isNegative = this.offsetMax.getTotalSeconds() < 0;
        int hour = this.calculateHourValue(this.offsetMax);
        int minute = this.calculateMinuteValue(this.offsetMax);
        int second = this.calculateSecondValue(this.offsetMax);
        if (second != 0 && isNegative && ++minute > 59) {
            minute -= 60;
            --hour;
        }
        while (minute % 15 != 0) {
            if (!isNegative || (minute -= isNegative ? -1 : 1) != 60) continue;
            minute = 0;
            --hour;
        }
        if (isNegative) {
            minute = -minute;
        }
        return ZoneOffset.ofHoursMinutes(hour, minute);
    }

    private int calculateIndex(ZoneOffset effective) {
        boolean isNegative = effective.getTotalSeconds() < 0;
        int hour = this.calculateHourValue(effective);
        int minuteVal = this.calculateMinuteValue(effective) / 15;
        if (isNegative) {
            minuteVal = -minuteVal;
        }
        return hour * 4 + minuteVal;
    }

    private static ZoneOffset calculateOffset(int index) {
        int hour = index / 4;
        int minute = (index -= hour * 4) * 15;
        return ZoneOffset.ofHoursMinutes(hour, minute);
    }

    private int calculateHourValue(ZoneOffset offset) {
        return offset.getTotalSeconds() / 3600;
    }

    private int calculateMinuteValue(ZoneOffset offset) {
        return Math.abs(offset.getTotalSeconds() % 3600 / 60);
    }

    private int calculateSecondValue(ZoneOffset offset) {
        return Math.abs(offset.getTotalSeconds() % 60);
    }

    @Override
    public ZoneOffsetArbitrary between(ZoneOffset min, ZoneOffset max) {
        if (min.getTotalSeconds() > max.getTotalSeconds()) {
            ZoneOffset remember = min;
            min = max;
            max = remember;
        }
        if (min.getTotalSeconds() < DEFAULT_MIN.getTotalSeconds() || min.getTotalSeconds() > DEFAULT_MAX.getTotalSeconds() || max.getTotalSeconds() > DEFAULT_MAX.getTotalSeconds()) {
            throw new IllegalArgumentException("Offset must be between -12:00:00 and +14:00:00.");
        }
        DefaultZoneOffsetArbitrary clone = (DefaultZoneOffsetArbitrary)this.typedClone();
        clone.offsetMin = min;
        clone.offsetMax = max;
        return clone;
    }
}

