/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.CalendarArbitrary;
import net.jqwik.time.api.arbitraries.DateArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import net.jqwik.time.api.constraints.DateRange;
import net.jqwik.time.internal.properties.arbitraries.DefaultCalendarArbitrary;

public class DateRangeConfigurator {
    private static boolean filter(LocalDate date, LocalDate min, LocalDate max) {
        return !date.isBefore(min) && !date.isAfter(max);
    }

    private static boolean filter(Calendar date, Calendar min, Calendar max) {
        return date.compareTo(min) >= 0 && date.compareTo(max) <= 0;
    }

    private static boolean filter(Date date, Date min, Date max) {
        return date.compareTo(min) >= 0 && date.compareTo(max) <= 0;
    }

    private static LocalDate isoDateToLocalDate(String iso) {
        return LocalDate.parse(iso);
    }

    private static Calendar isoDateToCalendar(String iso, boolean max) {
        LocalDate localDate = DateRangeConfigurator.isoDateToLocalDate(iso);
        Calendar calendar = DefaultCalendarArbitrary.localDateToCalendar(localDate);
        if (max) {
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
        }
        return calendar;
    }

    private static Date isoDateToDate(String iso, boolean max) {
        Calendar calendar = DateRangeConfigurator.isoDateToCalendar(iso, max);
        return calendar.getTime();
    }

    public static class ForDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Date.class);
        }

        public Arbitrary<Date> configure(Arbitrary<Date> arbitrary, DateRange range) {
            Date min = DateRangeConfigurator.isoDateToDate(range.min(), false);
            Date max = DateRangeConfigurator.isoDateToDate(range.max(), true);
            if (arbitrary instanceof DateArbitrary) {
                DateArbitrary dateArbitrary = (DateArbitrary)arbitrary;
                return dateArbitrary.between(min, max);
            }
            return arbitrary.filter(v -> DateRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForCalendar
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Calendar.class);
        }

        public Arbitrary<Calendar> configure(Arbitrary<Calendar> arbitrary, DateRange range) {
            Calendar min = DateRangeConfigurator.isoDateToCalendar(range.min(), false);
            Calendar max = DateRangeConfigurator.isoDateToCalendar(range.max(), true);
            if (arbitrary instanceof CalendarArbitrary) {
                CalendarArbitrary calendarArbitrary = (CalendarArbitrary)arbitrary;
                return calendarArbitrary.between(min, max);
            }
            return arbitrary.filter(v -> DateRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDate.class);
        }

        public Arbitrary<LocalDate> configure(Arbitrary<LocalDate> arbitrary, DateRange range) {
            LocalDate min = DateRangeConfigurator.isoDateToLocalDate(range.min());
            LocalDate max = DateRangeConfigurator.isoDateToLocalDate(range.max());
            if (arbitrary instanceof LocalDateArbitrary) {
                LocalDateArbitrary localDateArbitrary = (LocalDateArbitrary)arbitrary;
                return localDateArbitrary.between(min, max);
            }
            return arbitrary.filter(v -> DateRangeConfigurator.filter(v, min, max));
        }
    }
}

